/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.secretmanager;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceSettings;
import com.google.protobuf.ByteString;
import java.io.IOException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gcp.autoconfigure.secretmanager.GcpSecretManagerProperties;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.DefaultCredentialsProvider;
import org.springframework.cloud.gcp.core.DefaultGcpProjectIdProvider;
import org.springframework.cloud.gcp.core.GcpProjectIdProvider;
import org.springframework.cloud.gcp.core.UserAgentHeaderProvider;
import org.springframework.cloud.gcp.secretmanager.SecretManagerPropertySourceLocator;
import org.springframework.cloud.gcp.secretmanager.SecretManagerTemplate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@EnableConfigurationProperties(value={GcpSecretManagerProperties.class})
@ConditionalOnClass(value={SecretManagerServiceClient.class, SecretManagerTemplate.class})
@ConditionalOnProperty(value={"spring.cloud.gcp.secretmanager.enabled"}, matchIfMissing=true)
public class GcpSecretManagerBootstrapConfiguration {
    private final CredentialsProvider credentialsProvider;
    private final GcpProjectIdProvider gcpProjectIdProvider;

    public GcpSecretManagerBootstrapConfiguration(GcpSecretManagerProperties properties, ConfigurableEnvironment configurableEnvironment) throws IOException {
        this.credentialsProvider = new DefaultCredentialsProvider((CredentialsSupplier)properties);
        this.gcpProjectIdProvider = properties.getProjectId() != null ? properties::getProjectId : new DefaultGcpProjectIdProvider();
        configurableEnvironment.getConversionService().addConverter((Converter)new Converter<ByteString, String>(){

            public String convert(ByteString source) {
                return source.toStringUtf8();
            }
        });
        configurableEnvironment.getConversionService().addConverter((Converter)new Converter<ByteString, byte[]>(){

            public byte[] convert(ByteString source) {
                return source.toByteArray();
            }
        });
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerServiceClient secretManagerClient() throws IOException {
        SecretManagerServiceSettings settings = ((SecretManagerServiceSettings.Builder)((SecretManagerServiceSettings.Builder)SecretManagerServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setHeaderProvider((HeaderProvider)new UserAgentHeaderProvider(GcpSecretManagerBootstrapConfiguration.class))).build();
        return SecretManagerServiceClient.create((SecretManagerServiceSettings)settings);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerTemplate secretManagerTemplate(SecretManagerServiceClient client) {
        return new SecretManagerTemplate(client, this.gcpProjectIdProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public SecretManagerPropertySourceLocator secretManagerPropertySourceLocator(SecretManagerTemplate secretManagerTemplate) {
        SecretManagerPropertySourceLocator propertySourceLocator = new SecretManagerPropertySourceLocator(secretManagerTemplate, this.gcpProjectIdProvider);
        return propertySourceLocator;
    }
}

