/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.trace.sleuth;

import com.google.common.primitives.UnsignedLongs;
import com.google.devtools.cloudtrace.v1.TraceSpan;
import com.google.protobuf.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.gcp.autoconfigure.trace.sleuth.LabelExtractor;
import zipkin2.Span;

public class SpanTranslator {
    private final LabelExtractor labelExtractor;
    private final Map<Span.Kind, TraceSpan.SpanKind> SPAN_KIND_MAP;

    public SpanTranslator(LabelExtractor labelExtractor) {
        HashMap<Span.Kind, TraceSpan.SpanKind> map = new HashMap<Span.Kind, TraceSpan.SpanKind>();
        map.put(Span.Kind.CLIENT, TraceSpan.SpanKind.RPC_CLIENT);
        map.put(Span.Kind.SERVER, TraceSpan.SpanKind.RPC_SERVER);
        this.SPAN_KIND_MAP = Collections.unmodifiableMap(map);
        this.labelExtractor = labelExtractor;
    }

    public TraceSpan translate(Span zipkinSpan) {
        TraceSpan.Builder builder = TraceSpan.newBuilder();
        this.translate(builder, zipkinSpan);
        return builder.build();
    }

    TraceSpan.Builder translate(TraceSpan.Builder spanBuilder, Span zipkinSpan) {
        spanBuilder.setName(zipkinSpan.name() == null ? "" : zipkinSpan.name());
        TraceSpan.SpanKind kind = this.getSpanKind(zipkinSpan.kind());
        spanBuilder.setKind(kind);
        this.rewriteIds(zipkinSpan, spanBuilder, kind);
        if (zipkinSpan.timestampAsLong() != 0L) {
            spanBuilder.setStartTime(this.createTimestamp(zipkinSpan.timestamp()));
            if (zipkinSpan.durationAsLong() != 0L) {
                Timestamp endTime = this.createTimestamp(zipkinSpan.timestampAsLong() + zipkinSpan.durationAsLong());
                spanBuilder.setEndTime(endTime);
            }
        }
        spanBuilder.putAllLabels(this.labelExtractor.extract(zipkinSpan));
        return spanBuilder;
    }

    private void rewriteIds(Span zipkinSpan, TraceSpan.Builder builder, TraceSpan.SpanKind kind) {
        long id = this.parseUnsignedLong(zipkinSpan.id());
        long parentId = this.parseUnsignedLong(zipkinSpan.parentId());
        if (kind == TraceSpan.SpanKind.RPC_CLIENT) {
            builder.setSpanId(this.rewriteId(id));
        } else {
            builder.setSpanId(id);
        }
        if (kind == TraceSpan.SpanKind.RPC_SERVER) {
            if (Boolean.TRUE.equals(zipkinSpan.shared())) {
                builder.setParentSpanId(this.rewriteId(id));
            } else {
                builder.setParentSpanId(this.rewriteId(parentId));
            }
        } else {
            builder.setParentSpanId(parentId);
        }
    }

    private long parseUnsignedLong(String id) {
        if (id == null) {
            return 0L;
        }
        return UnsignedLongs.parseUnsignedLong((String)id, (int)16);
    }

    private long rewriteId(long id) {
        if (id == 0L) {
            return 0L;
        }
        long pad = 4569516190330831531L;
        return id ^ 0x3F6A2EC3C810C2ABL;
    }

    private TraceSpan.SpanKind getSpanKind(Span.Kind zipkinKind) {
        if (zipkinKind == null) {
            return TraceSpan.SpanKind.SPAN_KIND_UNSPECIFIED;
        }
        return this.SPAN_KIND_MAP.getOrDefault(zipkinKind, TraceSpan.SpanKind.UNRECOGNIZED);
    }

    public Timestamp createTimestamp(long microseconds) {
        long seconds = microseconds / 1000000L;
        int remainderMicros = (int)(microseconds % 1000000L);
        int remainderNanos = remainderMicros * 1000;
        return Timestamp.newBuilder().setSeconds(seconds).setNanos(remainderNanos).build();
    }
}

