/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.trace.sleuth;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.sleuth.TraceKeys;
import zipkin2.Annotation;
import zipkin2.Span;

public class LabelExtractor {
    public static final String DEFAULT_AGENT_NAME = "spring-cloud-gcp-trace";
    public static final String DEFAULT_PREFIX = "cloud.spring.io/";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd (HH:mm:ss.SSS z)";
    private final String agentName;
    private final String prefix;
    private final Map<String, String> labelRenameMap;
    private final DateFormat timestampFormat;

    public LabelExtractor() {
        this(LabelExtractor.newDefaultLabelRenameMap());
    }

    public LabelExtractor(TraceKeys traceKeys) {
        this(LabelExtractor.newDefaultLabelRenameMap(traceKeys));
    }

    public LabelExtractor(Map<String, String> labelRenameMap) {
        this(DEFAULT_AGENT_NAME, DEFAULT_PREFIX, labelRenameMap, new SimpleDateFormat(DEFAULT_TIMESTAMP_FORMAT));
    }

    public LabelExtractor(String agentName, String prefix, Map<String, String> labelRenameMap, DateFormat timestampFormat) {
        this.agentName = agentName;
        this.prefix = prefix;
        this.labelRenameMap = labelRenameMap;
        this.timestampFormat = timestampFormat;
    }

    public static Map<String, String> newDefaultLabelRenameMap() {
        HashMap<String, String> labelRenameMap = new HashMap<String, String>();
        labelRenameMap = new HashMap();
        labelRenameMap.put("http.host", "/http/host");
        labelRenameMap.put("http.method", "/http/method");
        labelRenameMap.put("http.status_code", "/http/status_code");
        labelRenameMap.put("http.request.size", "/http/request/size");
        labelRenameMap.put("http.response.size", "/http/response/size");
        labelRenameMap.put("http.url", "/http/url");
        labelRenameMap.put("http.path", "/http/path");
        labelRenameMap.put("http.route", "/http/route");
        return labelRenameMap;
    }

    public static Map<String, String> newDefaultLabelRenameMap(TraceKeys traceKeys) {
        HashMap<String, String> labelRenameMap = new HashMap<String, String>();
        TraceKeys.Http httpKeys = traceKeys.getHttp();
        labelRenameMap = new HashMap();
        labelRenameMap.put(httpKeys.getHost(), "/http/host");
        labelRenameMap.put(httpKeys.getMethod(), "/http/method");
        labelRenameMap.put(httpKeys.getStatusCode(), "/http/status_code");
        labelRenameMap.put(httpKeys.getRequestSize(), "/http/request/size");
        labelRenameMap.put(httpKeys.getResponseSize(), "/http/response/size");
        labelRenameMap.put(httpKeys.getUrl(), "/http/url");
        labelRenameMap.put(httpKeys.getPath(), "/http/path");
        return labelRenameMap;
    }

    public Map<String, String> extract(Span zipkinSpan) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry tag : zipkinSpan.tags().entrySet()) {
            result.put(this.label((String)tag.getKey()), (String)tag.getValue());
        }
        if (zipkinSpan.localEndpoint() != null && zipkinSpan.kind() == Span.Kind.SERVER) {
            if (zipkinSpan.localEndpoint().ipv4() != null) {
                result.put(this.label("endpoint.ipv4"), zipkinSpan.localEndpoint().ipv4());
            }
            if (zipkinSpan.localEndpoint().ipv6() != null) {
                result.put(this.label("endpoint.ipv6"), zipkinSpan.localEndpoint().ipv6());
            }
        }
        for (Annotation annotation : zipkinSpan.annotations()) {
            result.put(this.label(annotation.value()), this.formatTimestamp(annotation.timestamp()));
        }
        if (zipkinSpan.localEndpoint() != null && !zipkinSpan.localEndpoint().serviceName().isEmpty()) {
            result.put("/component", zipkinSpan.localEndpoint().serviceName());
        }
        if (zipkinSpan.parentId() == null) {
            String agentName = System.getProperty("stackdriver.trace.zipkin.agent", DEFAULT_AGENT_NAME);
            result.put("/agent", agentName);
        }
        return result;
    }

    protected String label(String key) {
        if (this.labelRenameMap.containsKey(key)) {
            return this.labelRenameMap.get(key);
        }
        return this.prefix + key;
    }

    protected String formatTimestamp(long milliseconds) {
        return this.timestampFormat.format(new Date(milliseconds));
    }
}

