/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.trace;

import com.google.cloud.trace.v1.TraceServiceClient;
import com.google.cloud.trace.v1.consumer.TraceConsumer;
import com.google.devtools.cloudtrace.v1.Traces;
import java.io.Closeable;
import java.io.IOException;

public class TraceServiceClientTraceConsumer
implements TraceConsumer,
Closeable {
    private final String projectId;
    private final TraceServiceClient client;

    public TraceServiceClientTraceConsumer(String projectId, TraceServiceClient client) {
        this.projectId = projectId;
        this.client = client;
    }

    public void receive(Traces traces) {
        this.client.patchTraces(this.projectId, traces);
    }

    @Override
    public void close() throws IOException {
        try {
            this.client.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

