/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.trace;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.gcp.core.Credentials;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.GcpScope;

@ConfigurationProperties(value="spring.cloud.gcp.trace")
public class GcpTraceProperties
implements CredentialsSupplier {
    private int executorThreads = 4;
    private int bufferSizeBytes = GcpTraceProperties.percentOfRuntimeTotalMemory(0.01f);
    private int scheduledDelaySeconds = 10;
    private String projectId;
    @NestedConfigurationProperty
    private final Credentials credentials = new Credentials(new String[]{GcpScope.TRACE_APPEND.getUrl()});

    static int percentOfRuntimeTotalMemory(float percentage) {
        long result = (long)((float)Runtime.getRuntime().totalMemory() * percentage);
        return (int)Math.max(Math.min(Integer.MAX_VALUE, result), Integer.MIN_VALUE);
    }

    public int getExecutorThreads() {
        return this.executorThreads;
    }

    public void setExecutorThreads(int executorThreads) {
        this.executorThreads = executorThreads;
    }

    public int getBufferSizeBytes() {
        return this.bufferSizeBytes;
    }

    public void setBufferSizeBytes(int bufferSizeBytes) {
        this.bufferSizeBytes = bufferSizeBytes;
    }

    public int getScheduledDelaySeconds() {
        return this.scheduledDelaySeconds;
    }

    public void setScheduledDelaySeconds(int scheduledDelaySeconds) {
        this.scheduledDelaySeconds = scheduledDelaySeconds;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }
}

