/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.pubsub;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.gcp.core.Credentials;
import org.springframework.cloud.gcp.core.CredentialsSupplier;
import org.springframework.cloud.gcp.core.GcpScope;

@ConfigurationProperties(value="spring.cloud.gcp.pubsub")
public class GcpPubSubProperties
implements CredentialsSupplier {
    private int subscriberExecutorThreads = 4;
    private int publisherExecutorThreads = 4;
    private String projectId;
    private String emulatorHost;
    @NestedConfigurationProperty
    private final Credentials credentials = new Credentials(new String[]{GcpScope.PUBSUB.getUrl()});

    public int getSubscriberExecutorThreads() {
        return this.subscriberExecutorThreads;
    }

    public void setSubscriberExecutorThreads(int subscriberExecutorThreads) {
        this.subscriberExecutorThreads = subscriberExecutorThreads;
    }

    public int getPublisherExecutorThreads() {
        return this.publisherExecutorThreads;
    }

    public void setPublisherExecutorThreads(int publisherExecutorThreads) {
        this.publisherExecutorThreads = publisherExecutorThreads;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getEmulatorHost() {
        return this.emulatorHost;
    }

    public void setEmulatorHost(String emulatorHost) {
        this.emulatorHost = emulatorHost;
    }
}

