/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.logging;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gcp.autoconfigure.logging.CompositeTraceIdExtractor;
import org.springframework.cloud.gcp.autoconfigure.logging.TraceIdLoggingWebMvcInterceptor;
import org.springframework.cloud.gcp.autoconfigure.logging.XCloudTraceIdExtractor;
import org.springframework.cloud.gcp.autoconfigure.logging.ZipkinTraceIdExtractor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class LoggingWebMvcConfigurer
implements WebMvcConfigurer {
    private final TraceIdLoggingWebMvcInterceptor interceptor;

    public LoggingWebMvcConfigurer(@Autowired(required=false) TraceIdLoggingWebMvcInterceptor interceptor) {
        this.interceptor = interceptor != null ? interceptor : new TraceIdLoggingWebMvcInterceptor(new CompositeTraceIdExtractor(new XCloudTraceIdExtractor(), new ZipkinTraceIdExtractor()));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.interceptor);
    }
}

