/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import org.springframework.beans.BeanUtils;
import org.springframework.cloud.gateway.support.Configurable;
import org.springframework.core.style.ToStringCreator;

public abstract class AbstractConfigurable<C>
implements Configurable<C> {
    private Class<C> configClass;

    protected AbstractConfigurable(Class<C> configClass) {
        this.configClass = configClass;
    }

    @Override
    public Class<C> getConfigClass() {
        return this.configClass;
    }

    @Override
    public C newConfig() {
        return (C)BeanUtils.instantiateClass(this.configClass);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("configClass", this.configClass).toString();
    }
}

