/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.netty.Connection;

public class NettyWriteResponseFilter
implements GlobalFilter,
Ordered {
    public static final int WRITE_RESPONSE_FILTER_ORDER = -1;
    private static final Log log = LogFactory.getLog(NettyWriteResponseFilter.class);
    private final List<MediaType> streamingMediaTypes;

    public NettyWriteResponseFilter(List<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes = streamingMediaTypes;
    }

    public int getOrder() {
        return -1;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return chain.filter(exchange).then(Mono.defer(() -> {
            MediaType contentType;
            Flux body;
            ServerHttpResponse response;
            block4: {
                Connection connection = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
                if (connection == null) {
                    return Mono.empty();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("NettyWriteResponseFilter start inbound: " + connection.channel().id().asShortText() + ", outbound: " + exchange.getLogPrefix()));
                }
                response = exchange.getResponse();
                body = connection.inbound().receive().retain().map(byteBuf -> this.wrap((ByteBuf)byteBuf, response));
                contentType = null;
                try {
                    contentType = response.getHeaders().getContentType();
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)"invalid media type", (Throwable)e);
                }
            }
            return this.isStreamingMediaType(contentType) ? response.writeAndFlushWith((Publisher)body.map(Flux::just)) : response.writeWith((Publisher)body);
        })).doFinally(signalType -> {
            if (signalType == SignalType.CANCEL || signalType == SignalType.ON_ERROR) {
                this.cleanup(exchange);
            }
        });
    }

    protected DataBuffer wrap(ByteBuf byteBuf, ServerHttpResponse response) {
        DataBufferFactory bufferFactory = response.bufferFactory();
        if (bufferFactory instanceof NettyDataBufferFactory) {
            NettyDataBufferFactory factory = (NettyDataBufferFactory)bufferFactory;
            return factory.wrap(byteBuf);
        }
        if (bufferFactory instanceof DefaultDataBufferFactory) {
            DefaultDataBuffer buffer = ((DefaultDataBufferFactory)bufferFactory).allocateBuffer(byteBuf.readableBytes());
            buffer.write(new ByteBuffer[]{byteBuf.nioBuffer()});
            byteBuf.release();
            return buffer;
        }
        throw new IllegalArgumentException("Unknown DataBufferFactory type " + bufferFactory.getClass());
    }

    private void cleanup(ServerWebExchange exchange) {
        Connection connection = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        if (connection != null) {
            connection.dispose();
        }
    }

    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (contentType != null) {
            for (int i = 0; i < this.streamingMediaTypes.size(); ++i) {
                if (!this.streamingMediaTypes.get(i).isCompatibleWith(contentType)) continue;
                return true;
            }
        }
        return false;
    }
}

