/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import org.springframework.cache.Cache;
import org.springframework.cloud.gateway.config.LocalResponseCacheAutoConfiguration;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheProperties;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheManagerFactory;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

public class LocalResponseCacheGatewayFilterFactory
extends AbstractGatewayFilterFactory<RouteCacheConfiguration> {
    private final Cache globalCache;
    ResponseCacheManagerFactory cacheManagerFactory;
    Duration configuredTimeToLive;

    public LocalResponseCacheGatewayFilterFactory(ResponseCacheManagerFactory cacheManagerFactory, Cache globalCache, Duration configuredTimeToLive) {
        super(RouteCacheConfiguration.class);
        this.cacheManagerFactory = cacheManagerFactory;
        this.globalCache = globalCache;
        this.configuredTimeToLive = configuredTimeToLive;
    }

    @Override
    public GatewayFilter apply(RouteCacheConfiguration config) {
        LocalResponseCacheProperties cacheProperties = this.mapRouteCacheConfig(config);
        if (this.shouldUseGlobalCacheConfiguration(config)) {
            return new ResponseCacheGatewayFilter(this.cacheManagerFactory.create(this.globalCache, this.configuredTimeToLive));
        }
        Cache routeCache = LocalResponseCacheAutoConfiguration.gatewayCacheManager(cacheProperties).getCache(config.getRouteId() + "-cache");
        return new ResponseCacheGatewayFilter(this.cacheManagerFactory.create(routeCache, cacheProperties.getTimeToLive()));
    }

    private boolean shouldUseGlobalCacheConfiguration(RouteCacheConfiguration config) {
        return Objects.isNull(config.getTimeToLive()) && Objects.isNull(config.getSize());
    }

    private LocalResponseCacheProperties mapRouteCacheConfig(RouteCacheConfiguration config) {
        LocalResponseCacheProperties responseCacheProperties = new LocalResponseCacheProperties();
        responseCacheProperties.setSize(config.getSize());
        responseCacheProperties.setTimeToLive(config.getTimeToLive());
        return responseCacheProperties;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return List.of("timeToLive", "size");
    }

    @Validated
    public static class RouteCacheConfiguration
    implements HasRouteId {
        private DataSize size;
        private Duration timeToLive;
        private String routeId;

        public DataSize getSize() {
            return this.size;
        }

        public RouteCacheConfiguration setSize(DataSize size) {
            this.size = size;
            return this;
        }

        public Duration getTimeToLive() {
            return this.timeToLive;
        }

        public RouteCacheConfiguration setTimeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }
    }
}

