/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.actuate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.cloud.gateway.actuate.AbstractGatewayControllerEndpoint;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.handler.predicate.RoutePredicateFactory;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.cloud.gateway.route.RouteDefinitionWriter;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import reactor.core.publisher.Mono;

@RestControllerEndpoint(id="gateway")
public class GatewayLegacyControllerEndpoint
extends AbstractGatewayControllerEndpoint {
    public GatewayLegacyControllerEndpoint(RouteDefinitionLocator routeDefinitionLocator, List<GlobalFilter> globalFilters, List<GatewayFilterFactory> gatewayFilterFactories, List<RoutePredicateFactory> routePredicates, RouteDefinitionWriter routeDefinitionWriter, RouteLocator routeLocator) {
        super(routeDefinitionLocator, globalFilters, gatewayFilterFactories, routePredicates, routeDefinitionWriter, routeLocator);
    }

    @GetMapping(value={"/routes"})
    public Mono<List<Map<String, Object>>> routes() {
        Mono routeDefs = this.routeDefinitionLocator.getRouteDefinitions().collectMap(RouteDefinition::getId);
        Mono routes = this.routeLocator.getRoutes().collectList();
        return Mono.zip((Mono)routeDefs, (Mono)routes).map(tuple -> {
            Map defs = (Map)tuple.getT1();
            List routeList = (List)tuple.getT2();
            ArrayList allRoutes = new ArrayList();
            routeList.forEach(route -> {
                HashMap<String, Object> r = new HashMap<String, Object>();
                r.put("route_id", route.getId());
                r.put("order", route.getOrder());
                if (defs.containsKey(route.getId())) {
                    r.put("route_definition", defs.get(route.getId()));
                } else {
                    HashMap<String, Object> obj = new HashMap<String, Object>();
                    obj.put("predicate", route.getPredicate().toString());
                    if (!route.getFilters().isEmpty()) {
                        ArrayList<String> filters = new ArrayList<String>();
                        for (GatewayFilter filter : route.getFilters()) {
                            filters.add(filter.toString());
                        }
                        obj.put("filters", filters);
                    }
                    if (!CollectionUtils.isEmpty(route.getMetadata())) {
                        obj.put("metadata", route.getMetadata());
                    }
                    if (!obj.isEmpty()) {
                        r.put("route_object", obj);
                    }
                }
                allRoutes.add(r);
            });
            return allRoutes;
        });
    }

    @GetMapping(value={"/routes/{id}"})
    public Mono<ResponseEntity<RouteDefinition>> route(@PathVariable String id) {
        return this.routeDefinitionLocator.getRouteDefinitions().filter(route -> route.getId().equals(id)).singleOrEmpty().map(ResponseEntity::ok).switchIfEmpty(Mono.just((Object)ResponseEntity.notFound().build()));
    }
}

