/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.server.mvc.common.ArgumentSupplier;
import org.springframework.cloud.gateway.server.mvc.common.AttributedArugmentSuppliedEvent;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.common.WeightConfig;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.style.ToStringCreator;

public class WeightCalculatorFilter
implements Filter,
Ordered,
SmartApplicationListener {
    public static final int WEIGHT_CALC_FILTER_ORDER = 10001;
    private static final Log log = LogFactory.getLog(WeightCalculatorFilter.class);
    private Supplier<Double> randomSupplier = null;
    private int order = 10001;
    private Map<String, GroupWeightConfig> groupWeights = new ConcurrentHashMap<String, GroupWeightConfig>();

    static Map<String, String> getWeights(ServletRequest request) {
        ConcurrentHashMap weights = (ConcurrentHashMap)request.getAttribute(MvcUtils.WEIGHT_ATTR);
        if (weights == null) {
            weights = new ConcurrentHashMap();
            request.setAttribute(MvcUtils.WEIGHT_ATTR, weights);
        }
        return weights;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setRandomSupplier(Supplier<Double> randomSupplier) {
        this.randomSupplier = randomSupplier;
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ArgumentSupplier.ArgumentSuppliedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        ArgumentSupplier.ArgumentSuppliedEvent argumentSuppliedEvent;
        if (event instanceof ArgumentSupplier.ArgumentSuppliedEvent && (argumentSuppliedEvent = (ArgumentSupplier.ArgumentSuppliedEvent)event).getType() == WeightConfig.class) {
            WeightConfig weightConfig = (WeightConfig)argumentSuppliedEvent.getArgument();
            if (weightConfig.getRouteId() == null && argumentSuppliedEvent instanceof AttributedArugmentSuppliedEvent) {
                AttributedArugmentSuppliedEvent attributed = (AttributedArugmentSuppliedEvent)argumentSuppliedEvent;
                String routeId = (String)attributed.getAttributes().get(MvcUtils.GATEWAY_ROUTE_ID_ATTR);
                weightConfig.setRouteId(routeId);
            }
            this.addWeightConfig(weightConfig);
        }
    }

    /*
     * WARNING - void declaration
     */
    void addWeightConfig(WeightConfig weightConfig) {
        void var7_11;
        String group = weightConfig.getGroup();
        GroupWeightConfig config = this.groupWeights.containsKey(group) ? new GroupWeightConfig(this.groupWeights.get(group)) : new GroupWeightConfig(group);
        config.weights.put(weightConfig.getRouteId(), weightConfig.getWeight());
        int weightsSum = 0;
        for (Integer n : config.weights.values()) {
            weightsSum += n.intValue();
        }
        AtomicInteger index = new AtomicInteger(0);
        for (Map.Entry<String, Integer> entry : config.weights.entrySet()) {
            String routeId = entry.getKey();
            Integer weight = entry.getValue();
            Double nomalizedWeight = (double)weight.intValue() / (double)weightsSum;
            config.normalizedWeights.put(routeId, nomalizedWeight);
            config.rangeIndexes.put(index.getAndIncrement(), routeId);
        }
        config.ranges.clear();
        config.ranges.add(0.0);
        ArrayList<Double> arrayList = new ArrayList<Double>(config.normalizedWeights.values());
        boolean bl = false;
        while (var7_11 < arrayList.size()) {
            Double currentWeight = (Double)arrayList.get((int)var7_11);
            Double previousRange = config.ranges.get((int)var7_11);
            Double range = previousRange + currentWeight;
            config.ranges.add(range);
            ++var7_11;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Recalculated group weight config " + String.valueOf(config)));
        }
        this.groupWeights.put(group, config);
    }

    Map<String, GroupWeightConfig> getGroupWeights() {
        return this.groupWeights;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Map<String, String> weights = WeightCalculatorFilter.getWeights(request);
        block0: for (String group : this.groupWeights.keySet()) {
            GroupWeightConfig config = this.groupWeights.get(group);
            if (config == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No GroupWeightConfig found for group: " + group));
                continue;
            }
            double r = this.randomSupplier != null ? this.randomSupplier.get().doubleValue() : ThreadLocalRandom.current().nextDouble();
            List<Double> ranges = config.ranges;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Weight for group: " + group + ", ranges: " + String.valueOf(ranges) + ", r: " + r));
            }
            for (int i = 0; i < ranges.size() - 1; ++i) {
                if (!(r >= ranges.get(i)) || !(r < ranges.get(i + 1))) continue;
                String routeId = config.rangeIndexes.get(i);
                weights.put(group, routeId);
                continue block0;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Weights attr: " + String.valueOf(weights)));
        }
        chain.doFilter(request, response);
    }

    static class GroupWeightConfig {
        String group;
        LinkedHashMap<String, Integer> weights = new LinkedHashMap();
        LinkedHashMap<String, Double> normalizedWeights = new LinkedHashMap();
        LinkedHashMap<Integer, String> rangeIndexes = new LinkedHashMap();
        List<Double> ranges = new ArrayList<Double>();

        GroupWeightConfig(String group) {
            this.group = group;
        }

        GroupWeightConfig(GroupWeightConfig other) {
            this.group = other.group;
            this.weights = new LinkedHashMap<String, Integer>(other.weights);
            this.normalizedWeights = new LinkedHashMap<String, Double>(other.normalizedWeights);
            this.rangeIndexes = new LinkedHashMap<Integer, String>(other.rangeIndexes);
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("group", (Object)this.group).append("weights", this.weights).append("normalizedWeights", this.normalizedWeights).append("rangeIndexes", this.rangeIndexes).toString();
        }
    }
}

