/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.util.HashMap;
import java.util.Optional;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public class GatewayDelegatingRouterFunction<T extends ServerResponse>
implements RouterFunction<T> {
    private final RouterFunction<T> delegate;
    private final String routeId;

    public GatewayDelegatingRouterFunction(RouterFunction<T> delegate, String routeId) {
        this.delegate = delegate;
        this.routeId = routeId;
    }

    public Optional<HandlerFunction<T>> route(ServerRequest request) {
        request.attributes().put(MvcUtils.GATEWAY_ROUTE_ID_ATTR, this.routeId);
        request.attributes().computeIfAbsent(MvcUtils.GATEWAY_ATTRIBUTES_ATTR, s -> new HashMap());
        Optional handlerFunction = this.delegate.route(request);
        request.attributes().remove(MvcUtils.GATEWAY_ROUTE_ID_ATTR);
        return handlerFunction;
    }

    public void accept(RouterFunctions.Visitor visitor) {
        this.delegate.accept(visitor);
    }

    public String toString() {
        return String.format("RouterFunction routeId=%s delegate=%s", this.routeId, this.delegate);
    }
}

