/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.predicate;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.server.mvc.common.ArgumentSupplier;
import org.springframework.cloud.gateway.server.mvc.common.DefaultArgumentSuppliedEvent;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.common.Shortcut;
import org.springframework.cloud.gateway.server.mvc.common.WeightConfig;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RequestPredicates;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public abstract class GatewayRequestPredicates {
    private static final Log log = LogFactory.getLog(GatewayRequestPredicates.class);
    private static final String X_CF_FORWARDED_URL = "X-CF-Forwarded-Url";
    private static final String X_CF_PROXY_SIGNATURE = "X-CF-Proxy-Signature";
    private static final String X_CF_PROXY_METADATA = "X-CF-Proxy-Metadata";
    private static final PathPatternParser DEFAULT_HOST_INSTANCE = new HostReadOnlyPathPatternParser();
    private static final String READ_BODY_CACHE_OBJECT_KEY = "cachedRequestBodyObject";

    private GatewayRequestPredicates() {
    }

    @Shortcut
    public static RequestPredicate after(ZonedDateTime dateTime) {
        return request -> ZonedDateTime.now().isAfter(dateTime);
    }

    @Shortcut
    public static RequestPredicate before(ZonedDateTime dateTime) {
        return request -> ZonedDateTime.now().isBefore(dateTime);
    }

    @Shortcut
    public static RequestPredicate between(ZonedDateTime dateTime1, ZonedDateTime dateTime2) {
        return request -> {
            ZonedDateTime now = ZonedDateTime.now();
            return now.isAfter(dateTime1) && now.isBefore(dateTime2);
        };
    }

    public static RequestPredicate cloudFoundryRouteService() {
        return GatewayRequestPredicates.header(X_CF_FORWARDED_URL).and(GatewayRequestPredicates.header(X_CF_PROXY_METADATA)).and(GatewayRequestPredicates.header(X_CF_PROXY_SIGNATURE));
    }

    public static RequestPredicate cookie(String name) {
        return GatewayRequestPredicates.cookie(name, null);
    }

    @Shortcut
    public static RequestPredicate cookie(String name, String regexp) {
        return new CookieRequestPredicate(name, regexp);
    }

    public static RequestPredicate header(String header) {
        return GatewayRequestPredicates.header(header, null);
    }

    @Shortcut
    public static RequestPredicate header(String header, String regexp) {
        return new HeaderRequestPredicate(header, regexp);
    }

    @Shortcut(type=Shortcut.Type.LIST)
    public static RequestPredicate method(HttpMethod ... methods) {
        return RequestPredicates.methods((HttpMethod[])methods);
    }

    public static RequestPredicate host(String pattern) {
        Assert.notNull((Object)pattern, (String)"'pattern' must not be null");
        return GatewayRequestPredicates.hostPredicates(DEFAULT_HOST_INSTANCE).apply(pattern);
    }

    @Shortcut(type=Shortcut.Type.LIST)
    public static RequestPredicate host(String ... patterns) {
        Assert.notEmpty((Object[])patterns, (String)"'patterns' must not be empty");
        RequestPredicate requestPredicate = GatewayRequestPredicates.hostPredicates(DEFAULT_HOST_INSTANCE).apply(patterns[0]);
        for (int i = 1; i < patterns.length; ++i) {
            requestPredicate = requestPredicate.or(GatewayRequestPredicates.hostPredicates(DEFAULT_HOST_INSTANCE).apply(patterns[i]));
        }
        return requestPredicate;
    }

    public static Function<String, RequestPredicate> hostPredicates(PathPatternParser patternParser) {
        Assert.notNull((Object)patternParser, (String)"PathPatternParser must not be null");
        return pattern -> new HostPatternPredicate(patternParser.parse(pattern));
    }

    public static RequestPredicate path(String pattern) {
        return RequestPredicates.path((String)pattern);
    }

    @Shortcut(type=Shortcut.Type.LIST)
    public static RequestPredicate path(String ... patterns) {
        Assert.notEmpty((Object[])patterns, (String)"'patterns' must not be empty");
        RequestPredicate requestPredicate = RequestPredicates.path((String)patterns[0]);
        for (int i = 1; i < patterns.length; ++i) {
            requestPredicate = requestPredicate.or(RequestPredicates.path((String)patterns[i]));
        }
        return requestPredicate;
    }

    @Shortcut
    public static RequestPredicate query(String param) {
        return GatewayRequestPredicates.query(param, null);
    }

    @Shortcut
    public static RequestPredicate query(String param, String regexp) {
        if (!StringUtils.hasText((String)regexp)) {
            return request -> request.param(param).isPresent();
        }
        return request -> request.param(param).stream().anyMatch(value -> value.matches(regexp));
    }

    public static <T> RequestPredicate readBody(Class<T> inClass, Predicate<T> predicate) {
        return new ReadBodyPredicate<T>(inClass, predicate);
    }

    @Shortcut
    public static RequestPredicate version(String version) {
        return RequestPredicates.version((Object)version);
    }

    @Shortcut
    public static RequestPredicate weight(String group, int weight) {
        return new WeightPredicate(group, weight);
    }

    private static void traceMatch(String prefix, Object desired, @Nullable Object actual, boolean match) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("%s \"%s\" %s against value \"%s\"", prefix, desired, match ? "matches" : "does not match", actual));
        }
    }

    private static class CookieRequestPredicate
    implements RequestPredicate {
        private final String name;
        private final Pattern pattern;

        CookieRequestPredicate(String name, String regexp) {
            this.name = name;
            this.pattern = StringUtils.hasText((String)regexp) ? Pattern.compile(regexp) : null;
        }

        public boolean test(ServerRequest request) {
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request.servletRequest())) {
                return true;
            }
            List cookies = (List)request.cookies().get((Object)this.name);
            if (ObjectUtils.isEmpty((Object)cookies)) {
                return false;
            }
            if (this.pattern != null) {
                for (Cookie cookie : cookies) {
                    if (!this.pattern.asMatchPredicate().test(cookie.getValue())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public void accept(RequestPredicates.Visitor visitor) {
            if (this.pattern != null) {
                visitor.header(this.name, this.pattern.pattern());
            } else {
                visitor.header(this.name, "");
            }
        }

        public String toString() {
            return String.format("Cookie: %s regexp=%s", this.name, this.pattern);
        }
    }

    private static class HeaderRequestPredicate
    implements RequestPredicate {
        private final String header;
        private final Pattern pattern;

        HeaderRequestPredicate(String header, String regexp) {
            this.header = header;
            this.pattern = StringUtils.hasText((String)regexp) ? Pattern.compile(regexp) : null;
        }

        public boolean test(ServerRequest request) {
            if (CorsUtils.isPreFlightRequest((HttpServletRequest)request.servletRequest())) {
                return true;
            }
            List values = request.headers().header(this.header);
            if (values.isEmpty()) {
                return false;
            }
            if (this.pattern != null) {
                for (String value : values) {
                    if (!this.pattern.asMatchPredicate().test(value)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        public void accept(RequestPredicates.Visitor visitor) {
            if (this.pattern != null) {
                visitor.header(this.header, this.pattern.pattern());
            } else {
                visitor.header(this.header, "");
            }
        }

        public String toString() {
            return String.format("Header: %s regexp=%s", this.header, this.pattern);
        }
    }

    private static final class ReadBodyPredicate<T>
    implements RequestPredicate {
        private final Class<T> toRead;
        private final Predicate<T> predicate;

        ReadBodyPredicate(Class<T> toRead, Predicate<T> predicate) {
            this.toRead = toRead;
            this.predicate = predicate;
        }

        public boolean test(ServerRequest request) {
            block3: {
                try {
                    Object cachedBody = MvcUtils.getAttribute(request, GatewayRequestPredicates.READ_BODY_CACHE_OBJECT_KEY);
                    if (cachedBody != null) {
                        return this.predicate.test(cachedBody);
                    }
                }
                catch (ClassCastException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Predicate test failed because class in predicate does not match the cached body object", (Throwable)e);
                }
            }
            return MvcUtils.cacheAndReadBody(request, this.toRead).map(body -> {
                MvcUtils.putAttribute(request, GatewayRequestPredicates.READ_BODY_CACHE_OBJECT_KEY, body);
                return this.predicate.test(body);
            }).orElse(false);
        }

        public void accept(RequestPredicates.Visitor visitor) {
            visitor.unknown((RequestPredicate)this);
        }

        public String toString() {
            return String.format("ReadBody=%s predicate=%s", this.toRead.getSimpleName(), this.predicate);
        }
    }

    private static final class WeightPredicate
    implements RequestPredicate,
    ArgumentSupplier<WeightConfig> {
        final String group;
        final int weight;

        private WeightPredicate(String group, int weight) {
            this.group = group;
            this.weight = weight;
        }

        public boolean test(ServerRequest request) {
            Map weights = request.attributes().getOrDefault(MvcUtils.WEIGHT_ATTR, Collections.emptyMap());
            String routeId = (String)request.attributes().get(MvcUtils.GATEWAY_ROUTE_ID_ATTR);
            if (ObjectUtils.isEmpty((Object)routeId)) {
                return false;
            }
            if (weights.containsKey(this.group)) {
                String chosenRoute = (String)weights.get(this.group);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("in group weight: " + this.group + ", current route: " + routeId + ", chosen route: " + chosenRoute));
                }
                return routeId.equals(chosenRoute);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("no weights found for group: " + this.group + ", current route: " + routeId));
            }
            return false;
        }

        public void accept(RequestPredicates.Visitor visitor) {
            visitor.unknown((RequestPredicate)this);
        }

        @Override
        public ArgumentSupplier.ArgumentSuppliedEvent<WeightConfig> getArgumentSuppliedEvent() {
            return new DefaultArgumentSuppliedEvent<WeightConfig>(this, WeightConfig.class, new WeightConfig(null, this.group, this.weight));
        }

        public String toString() {
            return String.format("Weight=%d group=%s", this.weight, this.group);
        }
    }

    private static class HostPatternPredicate
    implements RequestPredicate,
    ChangePathPatternParserVisitor.Target {
        private PathPattern pattern;

        HostPatternPredicate(PathPattern pattern) {
            Assert.notNull((Object)pattern, (String)"'pattern' must not be null");
            this.pattern = pattern;
        }

        public boolean test(ServerRequest request) {
            String host = request.headers().firstHeader("Host");
            if (host == null) {
                host = "";
            }
            PathContainer pathContainer = PathContainer.parsePath((String)host, (PathContainer.Options)PathContainer.Options.MESSAGE_ROUTE);
            PathPattern.PathMatchInfo info = this.pattern.matchAndExtract(pathContainer);
            GatewayRequestPredicates.traceMatch("Pattern", this.pattern.getPatternString(), host, info != null);
            if (info != null) {
                MvcUtils.putUriTemplateVariables(request, info.getUriVariables());
                return true;
            }
            return false;
        }

        public Optional<ServerRequest> nest(ServerRequest request) {
            throw new UnsupportedOperationException("nest is not supported");
        }

        public void accept(RequestPredicates.Visitor visitor) {
            visitor.header("Host", this.pattern.getPatternString());
        }

        @Override
        public void changeParser(PathPatternParser parser) {
            String patternString = this.pattern.getPatternString();
            this.pattern = parser.parse(patternString);
        }

        public String toString() {
            return this.pattern.getPatternString();
        }
    }

    private static class HostReadOnlyPathPatternParser
    extends PathPatternParser {
        HostReadOnlyPathPatternParser() {
            super.setPathOptions(PathContainer.Options.MESSAGE_ROUTE);
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.raiseError();
        }

        public void setPathOptions(PathContainer.Options pathOptions) {
            this.raiseError();
        }

        private void raiseError() {
            throw new UnsupportedOperationException("This is a read-only, shared instance that cannot be modified");
        }
    }

    public static class PredicateSupplier
    implements org.springframework.cloud.gateway.server.mvc.predicate.PredicateSupplier {
        @Override
        public Collection<Method> get() {
            return Arrays.asList(GatewayRequestPredicates.class.getMethods());
        }
    }

    private static class ChangePathPatternParserVisitor
    implements RouterFunctions.Visitor {
        private final PathPatternParser parser;

        ChangePathPatternParserVisitor(PathPatternParser parser) {
            Assert.notNull((Object)parser, (String)"Parser must not be null");
            this.parser = parser;
        }

        public void startNested(RequestPredicate predicate) {
            this.changeParser(predicate);
        }

        public void endNested(RequestPredicate predicate) {
        }

        public void route(RequestPredicate predicate, HandlerFunction<?> handlerFunction) {
            this.changeParser(predicate);
        }

        public void resources(Function<ServerRequest, Optional<Resource>> lookupFunction) {
        }

        public void attributes(Map<String, Object> attributes) {
        }

        public void unknown(RouterFunction<?> routerFunction) {
        }

        private void changeParser(RequestPredicate predicate) {
            if (predicate instanceof Target) {
                Target target = (Target)predicate;
                target.changeParser(this.parser);
            }
        }

        public static interface Target {
            public void changeParser(PathPatternParser var1);
        }
    }
}

