/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.springframework.http.HttpHeaders;
import org.springframework.messaging.MessageHeaders;

public final class FunctionHandlerHeaderUtils {
    public static final String HTTP_REQUEST_PARAM = "http_request_param";
    private static HttpHeaders IGNORED = new HttpHeaders();
    private static HttpHeaders REQUEST_ONLY = new HttpHeaders();

    private FunctionHandlerHeaderUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static HttpHeaders fromMessage(MessageHeaders headers, List<String> ignoredHeders) {
        HttpHeaders result = new HttpHeaders();
        for (String name : headers.keySet()) {
            Object value = headers.get((Object)name);
            if (IGNORED.containsHeader(name = name.toLowerCase(Locale.ROOT)) || ignoredHeders.contains(name)) continue;
            Collection<?> values = FunctionHandlerHeaderUtils.multi(value);
            for (Object object : values) {
                result.set(name, object.toString());
            }
        }
        return result;
    }

    public static HttpHeaders fromMessage(MessageHeaders headers) {
        return FunctionHandlerHeaderUtils.fromMessage(headers, Collections.EMPTY_LIST);
    }

    public static HttpHeaders sanitize(HttpHeaders request, List<String> ignoredHeders, List<String> requestOnlyHeaders) {
        HttpHeaders result = new HttpHeaders();
        for (String name : request.headerNames()) {
            List value = request.get(name);
            if (IGNORED.containsHeader(name = name.toLowerCase(Locale.ROOT)) || REQUEST_ONLY.containsHeader(name) || ignoredHeders.contains(name) || requestOnlyHeaders.contains(name)) continue;
            result.put(name, value);
        }
        return result;
    }

    public static HttpHeaders sanitize(HttpHeaders request) {
        return FunctionHandlerHeaderUtils.sanitize(request, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public static MessageHeaders fromHttp(HttpHeaders headers) {
        LinkedHashMap map = new LinkedHashMap();
        for (String name : headers.headerNames()) {
            Collection<?> value;
            Collection<?> values = FunctionHandlerHeaderUtils.multi(headers.get(name));
            name = name.toLowerCase(Locale.ROOT);
            Collection<?> collection = values == null ? null : (value = values.size() == 1 ? values.iterator().next() : values);
            if (name.toLowerCase(Locale.ROOT).equals("Content-Type".toLowerCase(Locale.ROOT))) {
                name = "contentType";
            }
            map.put(name, value);
        }
        return new MessageHeaders(map);
    }

    private static Collection<?> multi(Object value) {
        return value instanceof Collection ? (List<Object>)value : Arrays.asList(value);
    }

    static {
        IGNORED.add("id", "");
        IGNORED.add("Content-Length", "0");
        REQUEST_ONLY.add("Accept", "");
        REQUEST_ONLY.add("Content-Length", "");
        REQUEST_ONLY.add("Content-Type", "");
        REQUEST_ONLY.add("Host", "");
    }
}

