/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.RemoteAddrRoutePredicateFactory;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.cloud.gateway.support.ipresolver.XForwardedRemoteAddressResolver;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class XForwardedRemoteAddrRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    private static final Log log = LogFactory.getLog(XForwardedRemoteAddrRoutePredicateFactory.class);

    public XForwardedRemoteAddrRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public ShortcutConfigurable.ShortcutType shortcutType() {
        return ShortcutConfigurable.ShortcutType.GATHER_LIST;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("sources");
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Applying XForwardedRemoteAddr route predicate with maxTrustedIndex of " + config.getMaxTrustedIndex() + " for " + config.getSources().size() + " source(s)"));
        }
        RemoteAddrRoutePredicateFactory.Config wrappedConfig = new RemoteAddrRoutePredicateFactory.Config();
        wrappedConfig.setSources(config.getSources());
        wrappedConfig.setRemoteAddressResolver(XForwardedRemoteAddressResolver.maxTrustedIndex(config.getMaxTrustedIndex()));
        RemoteAddrRoutePredicateFactory remoteAddrRoutePredicateFactory = new RemoteAddrRoutePredicateFactory();
        Predicate<ServerWebExchange> wrappedPredicate = remoteAddrRoutePredicateFactory.apply(wrappedConfig);
        return exchange -> {
            Boolean isAllowed = wrappedPredicate.test((ServerWebExchange)exchange);
            if (log.isDebugEnabled()) {
                ServerHttpRequest request = exchange.getRequest();
                String clientAddress = request.getRemoteAddress() != null ? request.getRemoteAddress().getAddress().getHostAddress() : "unknown";
                log.debug((Object)("Request for \"" + String.valueOf(request.getURI()) + "\" from client \"" + clientAddress + "\" with \"X-Forwarded-For\" header value of \"" + String.valueOf(request.getHeaders().get("X-Forwarded-For")) + "\" is " + (isAllowed != false ? "ALLOWED" : "NOT ALLOWED")));
            }
            return isAllowed;
        };
    }

    public static class Config {
        private int maxTrustedIndex = 1;
        private List<String> sources = new ArrayList<String>();

        public int getMaxTrustedIndex() {
            return this.maxTrustedIndex;
        }

        public Config setMaxTrustedIndex(int maxTrustedIndex) {
            this.maxTrustedIndex = maxTrustedIndex;
            return this;
        }

        public List<String> getSources() {
            return this.sources;
        }

        public Config setSources(List<String> sources) {
            this.sources = sources;
            return this;
        }

        public Config setSources(String ... sources) {
            this.sources = Arrays.asList(sources);
            return this;
        }
    }
}

