/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.AsyncPredicate;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ReadBodyRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    protected static final Log log = LogFactory.getLog(ReadBodyRoutePredicateFactory.class);
    private static final String TEST_ATTRIBUTE = "read_body_predicate_test_attribute";
    private static final String CACHE_REQUEST_BODY_OBJECT_KEY = "cachedRequestBodyObject";
    private final List<HttpMessageReader<?>> messageReaders;

    public ReadBodyRoutePredicateFactory() {
        super(Config.class);
        this.messageReaders = HandlerStrategies.withDefaults().messageReaders();
    }

    public ReadBodyRoutePredicateFactory(List<HttpMessageReader<?>> messageReaders) {
        super(Config.class);
        this.messageReaders = messageReaders;
    }

    @Override
    public AsyncPredicate<ServerWebExchange> applyAsync(final Config config) {
        return new AsyncPredicate<ServerWebExchange>(){
            final /* synthetic */ ReadBodyRoutePredicateFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Publisher<Boolean> apply(ServerWebExchange exchange) {
                Class inClass = config.getInClass();
                Object cachedBody = exchange.getAttribute(ReadBodyRoutePredicateFactory.CACHE_REQUEST_BODY_OBJECT_KEY);
                if (cachedBody != null) {
                    try {
                        boolean test = config.predicate != null && config.predicate.test(cachedBody);
                        exchange.getAttributes().put(ReadBodyRoutePredicateFactory.TEST_ATTRIBUTE, test);
                        return Mono.just((Object)test);
                    }
                    catch (ClassCastException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Predicate test failed because class in predicate does not match the cached body object", (Throwable)e);
                        }
                        return Mono.just((Object)false);
                    }
                }
                Objects.requireNonNull(inClass, "inClass must not be null");
                return ServerWebExchangeUtils.cacheRequestBodyAndRequest(exchange, serverHttpRequest -> ServerRequest.create((ServerWebExchange)exchange.mutate().request(serverHttpRequest).build(), this.this$0.messageReaders).bodyToMono(inClass).doOnNext(objectValue -> exchange.getAttributes().put(ReadBodyRoutePredicateFactory.CACHE_REQUEST_BODY_OBJECT_KEY, objectValue)).map(objectValue -> config.getPredicate() != null && config.getPredicate().test(objectValue)));
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("ReadBody: %s", config.getInClass());
            }
        };
    }

    @Override
    public Predicate<ServerWebExchange> apply(Config config) {
        throw new UnsupportedOperationException("ReadBodyPredicateFactory is only async.");
    }

    public static class Config {
        private @Nullable Class inClass;
        private @Nullable Predicate predicate;
        private @Nullable Map<String, Object> hints;

        public @Nullable Class getInClass() {
            return this.inClass;
        }

        public Config setInClass(Class inClass) {
            this.inClass = inClass;
            return this;
        }

        public @Nullable Predicate getPredicate() {
            return this.predicate;
        }

        public Config setPredicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public <T> Config setPredicate(Class<T> inClass, Predicate<T> predicate) {
            this.setInClass(inClass);
            this.predicate = predicate;
            return this;
        }

        public @Nullable Map<String, Object> getHints() {
            return this.hints;
        }

        public Config setHints(Map<String, Object> hints) {
            this.hints = hints;
            return this;
        }
    }
}

