/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.ValidationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.support.NameUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@Validated
public class PredicateDefinition {
    private @Nullable String name;
    private Map<String, String> args = new LinkedHashMap<String, String>();

    public PredicateDefinition() {
    }

    public PredicateDefinition(String text) {
        int eqIdx = text.indexOf(61);
        if (eqIdx <= 0) {
            throw new ValidationException("Unable to parse PredicateDefinition text '" + text + "', must be of the form name=value");
        }
        this.setName(text.substring(0, eqIdx));
        String[] args = StringUtils.tokenizeToStringArray((String)text.substring(eqIdx + 1), (String)",");
        for (int i = 0; i < args.length; ++i) {
            this.args.put(NameUtils.generateName(i), args[i]);
        }
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public void setArgs(Map<String, String> args) {
        this.args = args;
    }

    public void addArg(String key, String value) {
        this.args.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateDefinition that = (PredicateDefinition)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.args);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PredicateDefinition{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", args=").append(this.args);
        sb.append('}');
        return sb.toString();
    }
}

