/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler.predicate;

import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.handler.predicate.AbstractRoutePredicateFactory;
import org.springframework.cloud.gateway.handler.predicate.GatewayPredicate;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;

public class BetweenRoutePredicateFactory
extends AbstractRoutePredicateFactory<Config> {
    public static final String DATETIME1_KEY = "datetime1";
    public static final String DATETIME2_KEY = "datetime2";

    public BetweenRoutePredicateFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(DATETIME1_KEY, DATETIME2_KEY);
    }

    @Override
    public Predicate<ServerWebExchange> apply(final Config config) {
        Objects.requireNonNull(config.getDatetime1(), "datetime1 must not be null");
        Assert.isTrue((boolean)config.getDatetime1().isBefore(config.getDatetime2()), (String)(String.valueOf(config.getDatetime1()) + " must be before " + String.valueOf(config.getDatetime2())));
        return new GatewayPredicate(){
            final /* synthetic */ BetweenRoutePredicateFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean test(ServerWebExchange serverWebExchange) {
                ZonedDateTime now = ZonedDateTime.now();
                return now.isAfter(config.getDatetime1()) && now.isBefore(config.getDatetime2());
            }

            @Override
            public Object getConfig() {
                return config;
            }

            public String toString() {
                return String.format("Between: %s and %s", config.getDatetime1(), config.getDatetime2());
            }
        };
    }

    public static class Config {
        @NotNull
        private @Nullable ZonedDateTime datetime1;
        @NotNull
        private @Nullable ZonedDateTime datetime2;

        public @Nullable ZonedDateTime getDatetime1() {
            return this.datetime1;
        }

        public Config setDatetime1(ZonedDateTime datetime1) {
            this.datetime1 = datetime1;
            return this;
        }

        public @Nullable ZonedDateTime getDatetime2() {
            return this.datetime2;
        }

        public Config setDatetime2(ZonedDateTime datetime2) {
            this.datetime2 = datetime2;
            return this;
        }
    }
}

