/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreakerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public abstract class SpringCloudCircuitBreakerFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String NAME = "CircuitBreaker";
    private ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory;
    private @Nullable ReactiveCircuitBreaker cb;
    private final ObjectProvider<DispatcherHandler> dispatcherHandlerProvider;
    private volatile @Nullable DispatcherHandler dispatcherHandler;

    public SpringCloudCircuitBreakerFilterFactory(ReactiveCircuitBreakerFactory reactiveCircuitBreakerFactory, ObjectProvider<DispatcherHandler> dispatcherHandlerProvider) {
        super(Config.class);
        this.reactiveCircuitBreakerFactory = reactiveCircuitBreakerFactory;
        this.dispatcherHandlerProvider = dispatcherHandlerProvider;
    }

    private @Nullable DispatcherHandler getDispatcherHandler() {
        if (this.dispatcherHandler == null) {
            this.dispatcherHandler = (DispatcherHandler)this.dispatcherHandlerProvider.getIfAvailable();
        }
        return this.dispatcherHandler;
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Collections.singletonList("name");
    }

    @Override
    public GatewayFilter apply(final Config config) {
        if (config.getFallbackUri() != null) {
            this.enableBodyCaching(config.getRouteId());
        }
        final ReactiveCircuitBreaker cb = this.reactiveCircuitBreakerFactory.create(config.getId());
        final Set statuses = config.getStatusCodes().stream().map(HttpStatusHolder::parse).filter(statusHolder -> statusHolder.getHttpStatus() != null).map(HttpStatusHolder::getHttpStatus).collect(Collectors.toSet());
        return new GatewayFilter(){
            final /* synthetic */ SpringCloudCircuitBreakerFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return cb.run(chain.filter(exchange).doOnSuccess(v -> {
                    if (statuses.contains(exchange.getResponse().getStatusCode())) {
                        HttpStatusCode status = Objects.requireNonNull(exchange.getResponse().getStatusCode(), "statusCode must not be null");
                        throw this.this$0.new CircuitBreakerStatusCodeException(status);
                    }
                }), t -> {
                    if (config.getFallbackUri() == null) {
                        return Mono.error((Throwable)t);
                    }
                    exchange.getResponse().setStatusCode(null);
                    URI uri = exchange.getRequest().getURI();
                    boolean encoded = ServerWebExchangeUtils.containsEncodedParts(uri);
                    String expandedFallbackUri = ServerWebExchangeUtils.expand(exchange, config.getFallbackUri().getPath());
                    String fullFallbackUri = String.format("%s:%s", config.getFallbackUri().getScheme(), expandedFallbackUri);
                    URI requestUrl = UriComponentsBuilder.fromUri((URI)uri).host(null).port(null).uri(URI.create(fullFallbackUri)).scheme(null).build(encoded).toUri();
                    exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR, requestUrl);
                    this.this$0.addExceptionDetails((Throwable)t, exchange);
                    ServerWebExchangeUtils.reset(exchange);
                    ServerHttpRequest request = exchange.getRequest().mutate().uri(requestUrl).build();
                    return ServerWebExchangeUtils.handle(this.this$0.getDispatcherHandler(), exchange.mutate().request(request).build());
                }).onErrorResume(t -> this.this$0.handleErrorWithoutFallback((Throwable)t, config.isResumeWithoutError()));
            }

            public String toString() {
                String name = config.getName();
                URI fallbackUri = config.getFallbackUri();
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("name", (Object)(name != null ? name : "")).append("fallback", fallbackUri != null ? fallbackUri : "").toString();
            }
        };
    }

    protected abstract Mono<Void> handleErrorWithoutFallback(Throwable var1, boolean var2);

    private void addExceptionDetails(Throwable t, ServerWebExchange exchange) {
        if (t != null) {
            exchange.getAttributes().put(ServerWebExchangeUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR, t);
        }
    }

    @Override
    public String name() {
        return NAME;
    }

    public static class Config
    implements HasRouteId {
        private @Nullable String name;
        private @Nullable URI fallbackUri;
        private @Nullable String routeId;
        private Set<String> statusCodes = new HashSet<String>();
        private boolean resumeWithoutError = false;

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public @Nullable String getRouteId() {
            return this.routeId;
        }

        public @Nullable URI getFallbackUri() {
            return this.fallbackUri;
        }

        public Config setFallbackUri(URI fallbackUri) {
            this.fallbackUri = fallbackUri;
            return this;
        }

        public Config setFallbackUri(String fallbackUri) {
            return this.setFallbackUri(URI.create(fallbackUri));
        }

        public @Nullable String getName() {
            return this.name;
        }

        public Config setName(String name) {
            this.name = name;
            return this;
        }

        public @Nullable String getId() {
            if (!StringUtils.hasText((String)this.name) && StringUtils.hasText((String)this.routeId)) {
                return this.routeId;
            }
            return this.name;
        }

        public Set<String> getStatusCodes() {
            return this.statusCodes;
        }

        public Config setStatusCodes(Set<String> statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        public Config addStatusCode(String statusCode) {
            this.statusCodes.add(statusCode);
            return this;
        }

        public boolean isResumeWithoutError() {
            return this.resumeWithoutError;
        }

        public void setResumeWithoutError(boolean resumeWithoutError) {
            this.resumeWithoutError = resumeWithoutError;
        }
    }

    public class CircuitBreakerStatusCodeException
    extends HttpStatusCodeException {
        public CircuitBreakerStatusCodeException(HttpStatusCode statusCode) {
            super(statusCode);
        }
    }
}

