/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.propagation.Propagator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.micrometer.tracing.autoconfigure.MicrometerTracingAutoConfiguration;
import org.springframework.boot.micrometer.tracing.autoconfigure.TracingProperties;
import org.springframework.cloud.gateway.config.GatewayMetricsAutoConfiguration;
import org.springframework.cloud.gateway.filter.headers.observation.GatewayPropagatingSenderTracingObservationHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.gateway.server.webflux.observability.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={GatewayMetricsAutoConfiguration.class, MicrometerTracingAutoConfiguration.class})
@ConditionalOnClass(value={DispatcherHandler.class, Tracer.class, TracingProperties.class, MicrometerTracingAutoConfiguration.class})
public class GatewayTracingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={Tracer.class, Propagator.class, TracingProperties.class})
    @Order(value=-2147483643)
    GatewayPropagatingSenderTracingObservationHandler gatewayPropagatingSenderTracingObservationHandler(Tracer tracer, Propagator propagator, TracingProperties tracingProperties) {
        return new GatewayPropagatingSenderTracingObservationHandler(tracer, propagator, tracingProperties.getBaggage().getRemoteFields());
    }
}

