/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class RemoveRequestParameterGatewayFilterFactory
extends AbstractGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    public RemoveRequestParameterGatewayFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name");
    }

    @Override
    public GatewayFilter apply(final AbstractGatewayFilterFactory.NameConfig config) {
        return new GatewayFilter(){
            final /* synthetic */ RemoveRequestParameterGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                ServerHttpRequest request = exchange.getRequest();
                LinkedMultiValueMap queryParams = new LinkedMultiValueMap((Map)request.getQueryParams());
                queryParams.remove((Object)config.getName());
                try {
                    MultiValueMap<String, String> encodedQueryParams = ServerWebExchangeUtils.encodeQueryParams((MultiValueMap<String, String>)queryParams);
                    URI newUri = UriComponentsBuilder.fromUri((URI)request.getURI()).replaceQueryParams(CollectionUtils.unmodifiableMultiValueMap(encodedQueryParams)).build(true).toUri();
                    ServerHttpRequest updatedRequest = exchange.getRequest().mutate().uri(newUri).build();
                    return chain.filter(exchange.mutate().request(updatedRequest).build());
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException("Invalid URI query: \"" + String.valueOf(queryParams) + "\"");
                }
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("name", (Object)config.getName()).toString();
            }
        };
    }
}

