/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HasRouteId;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.cloud.gateway.support.TimeoutException;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.retry.Backoff;
import reactor.retry.Jitter;
import reactor.retry.Repeat;
import reactor.retry.RepeatContext;
import reactor.retry.RetryContext;
import reactor.util.retry.Retry;

public class RetryGatewayFilterFactory
extends AbstractGatewayFilterFactory<RetryConfig> {
    public static final String RETRY_ITERATION_KEY = "retry_iteration";
    private static final Log log = LogFactory.getLog(RetryGatewayFilterFactory.class);

    public RetryGatewayFilterFactory() {
        super(RetryConfig.class);
    }

    private static <T> List<T> toList(T ... items) {
        return new ArrayList<T>(Arrays.asList(items));
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("retries", "statuses", "methods", "backoff.firstBackoff", "backoff.maxBackoff", "backoff.factor", "backoff.basedOnPreviousValue", "jitter.randomFactor", "timeout");
    }

    @Override
    public GatewayFilter apply(final RetryConfig retryConfig) {
        retryConfig.validate();
        Repeat statusCodeRepeat = null;
        if (!retryConfig.getStatuses().isEmpty() || !retryConfig.getSeries().isEmpty()) {
            Duration timeout;
            JitterConfig jitter;
            Predicate<RepeatContext> repeatPredicate = context -> {
                ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
                if (this.exceedsMaxIterations(exchange, retryConfig)) {
                    return false;
                }
                HttpStatusCode statusCode = exchange.getResponse().getStatusCode();
                boolean retryableStatusCode = retryConfig.getStatuses().contains(statusCode);
                if (!retryableStatusCode && statusCode != null) {
                    retryableStatusCode = false;
                    for (int i = 0; i < retryConfig.getSeries().size(); ++i) {
                        HttpStatus httpStatus;
                        if (!(statusCode instanceof HttpStatus) || !(httpStatus = (HttpStatus)statusCode).series().equals((Object)retryConfig.getSeries().get(i))) continue;
                        retryableStatusCode = true;
                        break;
                    }
                }
                boolean finalRetryableStatusCode = retryableStatusCode;
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = () -> finalRetryableStatusCode;
                supplierArray[1] = () -> statusCode;
                supplierArray[2] = retryConfig::getStatuses;
                supplierArray[3] = retryConfig::getSeries;
                this.trace("retryableStatusCode: %b, statusCode %s, configured statuses %s, configured series %s", supplierArray);
                HttpMethod httpMethod = exchange.getRequest().getMethod();
                boolean retryableMethod = retryConfig.getMethods().contains(httpMethod);
                Supplier[] supplierArray2 = new Supplier[3];
                supplierArray2[0] = () -> retryableMethod;
                supplierArray2[1] = () -> httpMethod;
                supplierArray2[2] = retryConfig::getMethods;
                this.trace("retryableMethod: %b, httpMethod %s, configured methods %s", supplierArray2);
                return retryableMethod && finalRetryableStatusCode;
            };
            statusCodeRepeat = Repeat.onlyIf(repeatPredicate).doOnRepeat(context -> this.reset((ServerWebExchange)context.applicationContext()));
            BackoffConfig backoff = retryConfig.getBackoff();
            if (backoff != null) {
                statusCodeRepeat = statusCodeRepeat.backoff(this.getBackoff(backoff));
            }
            if ((jitter = retryConfig.getJitter()) != null) {
                statusCodeRepeat = statusCodeRepeat.jitter(this.getJitter(jitter));
            }
            if ((timeout = retryConfig.getTimeout()) != null) {
                statusCodeRepeat = statusCodeRepeat.timeout(timeout);
            }
        }
        reactor.retry.Retry exceptionRetry = null;
        if (!retryConfig.getExceptions().isEmpty()) {
            Duration timeout;
            JitterConfig jitter;
            Predicate<RetryContext> retryContextPredicate = context -> {
                ServerWebExchange exchange = (ServerWebExchange)context.applicationContext();
                if (this.exceedsMaxIterations(exchange, retryConfig)) {
                    return false;
                }
                Throwable exception = context.exception();
                for (Class<? extends Throwable> retryableClass : retryConfig.getExceptions()) {
                    if (!retryableClass.isInstance(exception) && (exception == null || !retryableClass.isInstance(exception.getCause()))) continue;
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> this.getExceptionNameWithCause(exception);
                    supplierArray[1] = retryConfig::getExceptions;
                    this.trace("exception or its cause is retryable %s, configured exceptions %s", supplierArray);
                    HttpMethod httpMethod = exchange.getRequest().getMethod();
                    boolean retryableMethod = retryConfig.getMethods().contains(httpMethod);
                    Supplier[] supplierArray2 = new Supplier[3];
                    supplierArray2[0] = () -> retryableMethod;
                    supplierArray2[1] = () -> httpMethod;
                    supplierArray2[2] = retryConfig::getMethods;
                    this.trace("retryableMethod: %b, httpMethod %s, configured methods %s", supplierArray2);
                    return retryableMethod;
                }
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = () -> this.getExceptionNameWithCause(exception);
                supplierArray[1] = retryConfig::getExceptions;
                this.trace("exception or its cause is not retryable %s, configured exceptions %s", supplierArray);
                return false;
            };
            exceptionRetry = reactor.retry.Retry.onlyIf(retryContextPredicate).doOnRetry(context -> this.reset((ServerWebExchange)context.applicationContext())).retryMax((long)retryConfig.getRetries());
            BackoffConfig backoff = retryConfig.getBackoff();
            if (backoff != null) {
                exceptionRetry = exceptionRetry.backoff(this.getBackoff(backoff));
            }
            if ((jitter = retryConfig.getJitter()) != null) {
                exceptionRetry = exceptionRetry.jitter(this.getJitter(jitter));
            }
            if ((timeout = retryConfig.getTimeout()) != null) {
                exceptionRetry = exceptionRetry.timeout(timeout);
            }
        }
        final GatewayFilter gatewayFilter = this.apply(retryConfig.getRouteId(), (Repeat<ServerWebExchange>)statusCodeRepeat, exceptionRetry);
        return new GatewayFilter(){
            final /* synthetic */ RetryGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return gatewayFilter.filter(exchange, chain);
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("routeId", (Object)retryConfig.getRouteId()).append("retries", retryConfig.getRetries()).append("series", retryConfig.getSeries()).append("statuses", retryConfig.getStatuses()).append("methods", retryConfig.getMethods()).append("exceptions", retryConfig.getExceptions()).append("backoff", (Object)retryConfig.getBackoff()).append("jitter", (Object)retryConfig.getJitter()).append("timeout", (Object)retryConfig.getTimeout()).toString();
            }
        };
    }

    private String getExceptionNameWithCause(Throwable exception) {
        if (exception != null) {
            StringBuilder builder = new StringBuilder(exception.getClass().getName());
            Throwable cause = exception.getCause();
            if (cause != null) {
                builder.append("{cause=").append(cause.getClass().getName()).append("}");
            }
            return builder.toString();
        }
        return "null";
    }

    private Backoff getBackoff(BackoffConfig backoff) {
        return Backoff.exponential((Duration)backoff.firstBackoff, (Duration)backoff.maxBackoff, (int)backoff.factor, (boolean)backoff.basedOnPreviousValue);
    }

    private Jitter getJitter(JitterConfig jitter) {
        return Jitter.random((double)jitter.randomFactor);
    }

    public boolean exceedsMaxIterations(ServerWebExchange exchange, RetryConfig retryConfig) {
        Integer iteration = (Integer)exchange.getAttribute(RETRY_ITERATION_KEY);
        boolean exceeds = iteration != null && iteration >= retryConfig.getRetries();
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> exceeds;
        supplierArray[1] = () -> iteration;
        supplierArray[2] = retryConfig::getRetries;
        this.trace("exceedsMaxIterations %b, iteration %d, configured retries %d", supplierArray);
        return exceeds;
    }

    @Deprecated
    public void reset(ServerWebExchange exchange) {
        Connection conn = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        if (conn != null) {
            this.trace("disposing response connection before next iteration", new Supplier[0]);
            conn.dispose();
            exchange.getAttributes().remove(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        }
        ServerWebExchangeUtils.reset(exchange);
    }

    public GatewayFilter apply(String routeId, Repeat<ServerWebExchange> repeat, reactor.retry.Retry<ServerWebExchange> retry) {
        this.enableBodyCaching(routeId);
        return (exchange, chain) -> {
            this.trace("Entering retry-filter", new Supplier[0]);
            Mono publisher = chain.filter(exchange).doOnSuccess(aVoid -> this.updateIteration(exchange)).doOnError(throwable -> this.updateIteration(exchange));
            if (retry != null) {
                publisher = publisher.retryWhen(Retry.withThrowable((Function)retry.withApplicationContext((Object)exchange)));
            }
            if (repeat != null) {
                publisher = publisher.repeatWhen((Function)repeat.withApplicationContext((Object)exchange));
            }
            return Mono.fromDirect((Publisher)publisher);
        };
    }

    private void updateIteration(ServerWebExchange exchange) {
        int iteration = (Integer)exchange.getAttributeOrDefault(RETRY_ITERATION_KEY, (Object)-1);
        int newIteration = iteration + 1;
        this.trace("setting new iteration in attr %d", () -> newIteration);
        exchange.getAttributes().put(RETRY_ITERATION_KEY, newIteration);
    }

    @SafeVarargs
    private final void trace(String message, Supplier<Object> ... argSuppliers) {
        if (log.isTraceEnabled()) {
            Object[] args = new Object[argSuppliers.length];
            int i = 0;
            for (Supplier<Object> a : argSuppliers) {
                args[i] = a.get();
                ++i;
            }
            log.trace((Object)String.format(message, args));
        }
    }

    public static class RetryConfig
    implements HasRouteId {
        private String routeId;
        private int retries = 3;
        private List<HttpStatus.Series> series = RetryGatewayFilterFactory.toList(HttpStatus.Series.SERVER_ERROR);
        private List<HttpStatus> statuses = new ArrayList<HttpStatus>();
        private List<HttpMethod> methods = RetryGatewayFilterFactory.toList(HttpMethod.GET);
        private List<Class<? extends Throwable>> exceptions = RetryGatewayFilterFactory.toList(IOException.class, TimeoutException.class);
        private BackoffConfig backoff;
        private JitterConfig jitter;
        private Duration timeout;

        public RetryConfig allMethods() {
            return this.setMethods(HttpMethod.values());
        }

        public void validate() {
            Assert.isTrue((this.retries > 0 ? 1 : 0) != 0, (String)"retries must be greater than 0");
            Assert.isTrue((!this.series.isEmpty() || !this.statuses.isEmpty() || !this.exceptions.isEmpty() ? 1 : 0) != 0, (String)"series, status and exceptions may not all be empty");
            Assert.notEmpty(this.methods, (String)"methods may not be empty");
            if (this.backoff != null) {
                this.backoff.validate();
            }
            if (this.jitter != null) {
                this.jitter.validate();
            }
            if (this.timeout != null) {
                Assert.isTrue((!this.timeout.isNegative() ? 1 : 0) != 0, (String)"timeout should be >= 0");
            }
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public RetryConfig setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public JitterConfig getJitter() {
            return this.jitter;
        }

        public RetryConfig setJitter(JitterConfig jitter) {
            this.jitter = jitter;
            return this;
        }

        public RetryConfig setJitter(double randomFactor) {
            this.jitter = new JitterConfig(randomFactor);
            return this;
        }

        public BackoffConfig getBackoff() {
            return this.backoff;
        }

        public RetryConfig setBackoff(BackoffConfig backoff) {
            this.backoff = backoff;
            return this;
        }

        public RetryConfig setBackoff(Duration firstBackoff, Duration maxBackoff, int factor, boolean basedOnPreviousValue) {
            this.backoff = new BackoffConfig(firstBackoff, maxBackoff, factor, basedOnPreviousValue);
            return this;
        }

        @Override
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @Override
        public String getRouteId() {
            return this.routeId;
        }

        public int getRetries() {
            return this.retries;
        }

        public RetryConfig setRetries(int retries) {
            this.retries = retries;
            return this;
        }

        public List<HttpStatus.Series> getSeries() {
            return this.series;
        }

        public RetryConfig setSeries(HttpStatus.Series ... series) {
            this.series = Arrays.asList(series);
            return this;
        }

        public List<HttpStatus> getStatuses() {
            return this.statuses;
        }

        public RetryConfig setStatuses(HttpStatus ... statuses) {
            this.statuses = Arrays.asList(statuses);
            return this;
        }

        public List<HttpMethod> getMethods() {
            return this.methods;
        }

        public RetryConfig setMethods(HttpMethod ... methods) {
            this.methods = Arrays.asList(methods);
            return this;
        }

        public List<Class<? extends Throwable>> getExceptions() {
            return this.exceptions;
        }

        public RetryConfig setExceptions(Class<? extends Throwable> ... exceptions) {
            this.exceptions = Arrays.asList(exceptions);
            return this;
        }
    }

    public static class BackoffConfig {
        private Duration firstBackoff = Duration.ofMillis(5L);
        private Duration maxBackoff;
        private int factor = 2;
        private boolean basedOnPreviousValue = true;

        public BackoffConfig() {
        }

        public BackoffConfig(Duration firstBackoff, Duration maxBackoff, int factor, boolean basedOnPreviousValue) {
            this.firstBackoff = firstBackoff;
            this.maxBackoff = maxBackoff;
            this.factor = factor;
            this.basedOnPreviousValue = basedOnPreviousValue;
        }

        public void validate() {
            Assert.notNull((Object)this.firstBackoff, (String)"firstBackoff must be present");
        }

        public Duration getFirstBackoff() {
            return this.firstBackoff;
        }

        public void setFirstBackoff(Duration firstBackoff) {
            this.firstBackoff = firstBackoff;
        }

        public Duration getMaxBackoff() {
            return this.maxBackoff;
        }

        public void setMaxBackoff(Duration maxBackoff) {
            this.maxBackoff = maxBackoff;
        }

        public int getFactor() {
            return this.factor;
        }

        public void setFactor(int factor) {
            this.factor = factor;
        }

        public boolean isBasedOnPreviousValue() {
            return this.basedOnPreviousValue;
        }

        public void setBasedOnPreviousValue(boolean basedOnPreviousValue) {
            this.basedOnPreviousValue = basedOnPreviousValue;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("firstBackoff", (Object)this.firstBackoff).append("maxBackoff", (Object)this.maxBackoff).append("factor", this.factor).append("basedOnPreviousValue", this.basedOnPreviousValue).toString();
        }
    }

    public static class JitterConfig {
        private double randomFactor = 0.5;

        public void validate() {
            Assert.isTrue((this.randomFactor >= 0.0 && this.randomFactor <= 1.0 ? 1 : 0) != 0, (String)"random factor must be between 0 and 1 (default 0.5)");
        }

        public JitterConfig() {
        }

        public JitterConfig(double randomFactor) {
            this.randomFactor = randomFactor;
        }

        public double getRandomFactor() {
            return this.randomFactor;
        }

        public void setRandomFactor(double randomFactor) {
            this.randomFactor = randomFactor;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("randomFactor", this.randomFactor).toString();
        }
    }
}

