/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.TrustedProxies;
import org.springframework.cloud.gateway.server.mvc.filter.XForwardedRequestHeadersFilterProperties;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.ServerRequest;

@ConfigurationProperties(value="spring.cloud.gateway.x-forwarded")
public class XForwardedRequestHeadersFilter
implements HttpHeadersFilter.RequestHttpHeadersFilter,
Ordered {
    private static final Log log = LogFactory.getLog(XForwardedRequestHeadersFilter.class);
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    public static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    public static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    public static final String X_FORWARDED_PREFIX_HEADER = "X-Forwarded-Prefix";
    private int order = 0;
    private boolean enabled = true;
    private boolean forEnabled = true;
    private boolean hostEnabled = true;
    private boolean portEnabled = true;
    private boolean protoEnabled = true;
    private boolean prefixEnabled = true;
    private boolean forAppend = true;
    private boolean hostAppend = true;
    private boolean portAppend = true;
    private boolean protoAppend = true;
    private boolean prefixAppend = true;
    private final TrustedProxies trustedProxies;

    @Deprecated
    public XForwardedRequestHeadersFilter() {
        this(new XForwardedRequestHeadersFilterProperties(), (String s) -> true);
        log.warn((Object)"spring.cloud.gateway.mvc.trusted-proxies is not set. Using deprecated Constructor. Untrusted hosts might be added to X-Forwarded header.");
    }

    @Deprecated
    public XForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties props) {
        this(props, (String s) -> true);
        log.warn((Object)"spring.cloud.gateway.mvc.trusted-proxies is not set. Using deprecated Constructor. Untrusted hosts might be added to X-Forwarded header.");
    }

    public XForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties props, String trustedProxies) {
        this(props, TrustedProxies.from(trustedProxies));
    }

    private XForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties props, TrustedProxies trustedProxies) {
        Assert.notNull((Object)trustedProxies, (String)"trustedProxies must not be null");
        PropertyMapper map = PropertyMapper.get();
        map.from(props::getOrder).to(o -> {
            this.order = o;
        });
        map.from(props::isEnabled).to(b -> {
            this.enabled = b;
        });
        map.from(props::isForEnabled).to(b -> {
            this.forEnabled = b;
        });
        map.from(props::isHostEnabled).to(b -> {
            this.hostEnabled = b;
        });
        map.from(props::isPortEnabled).to(b -> {
            this.portEnabled = b;
        });
        map.from(props::isProtoEnabled).to(b -> {
            this.protoEnabled = b;
        });
        map.from(props::isPrefixEnabled).to(b -> {
            this.prefixEnabled = b;
        });
        map.from(props::isForAppend).to(b -> {
            this.forAppend = b;
        });
        map.from(props::isHostAppend).to(b -> {
            this.hostAppend = b;
        });
        map.from(props::isPortAppend).to(b -> {
            this.portAppend = b;
        });
        map.from(props::isProtoAppend).to(b -> {
            this.protoAppend = b;
        });
        map.from(props::isPrefixAppend).to(b -> {
            this.prefixAppend = b;
        });
        this.trustedProxies = trustedProxies;
    }

    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.order")
    public int getOrder() {
        return this.order;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setOrder(int order) {
        this.order = order;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.for-enabled")
    public boolean isForEnabled() {
        return this.forEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setForEnabled(boolean forEnabled) {
        this.forEnabled = forEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.host-enabled")
    public boolean isHostEnabled() {
        return this.hostEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setHostEnabled(boolean hostEnabled) {
        this.hostEnabled = hostEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.port-enabled")
    public boolean isPortEnabled() {
        return this.portEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPortEnabled(boolean portEnabled) {
        this.portEnabled = portEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.proto-enabled")
    public boolean isProtoEnabled() {
        return this.protoEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setProtoEnabled(boolean protoEnabled) {
        this.protoEnabled = protoEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.prefix-enabled")
    public boolean isPrefixEnabled() {
        return this.prefixEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPrefixEnabled(boolean prefixEnabled) {
        this.prefixEnabled = prefixEnabled;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.for-append")
    public boolean isForAppend() {
        return this.forAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setForAppend(boolean forAppend) {
        this.forAppend = forAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.host-append")
    public boolean isHostAppend() {
        return this.hostAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setHostAppend(boolean hostAppend) {
        this.hostAppend = hostAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.port-append")
    public boolean isPortAppend() {
        return this.portAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPortAppend(boolean portAppend) {
        this.portAppend = portAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.proto-append")
    public boolean isProtoAppend() {
        return this.protoAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setProtoAppend(boolean protoAppend) {
        this.protoAppend = protoAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    @DeprecatedConfigurationProperty(replacement="spring.cloud.gateway.mvc.x-forwarded-request-headers-filter.prefix-append")
    public boolean isPrefixAppend() {
        return this.prefixAppend;
    }

    @Deprecated(since="4.1.2", forRemoval=true)
    public void setPrefixAppend(boolean prefixAppend) {
        this.prefixAppend = prefixAppend;
    }

    @Override
    public HttpHeaders apply(HttpHeaders input, ServerRequest request) {
        if (request.servletRequest().getRemoteAddr() != null && !this.trustedProxies.isTrusted(request.servletRequest().getRemoteAddr())) {
            log.trace((Object)LogMessage.format((String)"Remote address not trusted. pattern %s remote address %s", (Object)this.trustedProxies, (Object)request.servletRequest().getRemoteHost()));
            return input;
        }
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        for (Map.Entry entry : original.headerSet()) {
            updated.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        if (this.isForEnabled()) {
            String remoteAddr = null;
            if (request.servletRequest().getRemoteAddr() != null) {
                remoteAddr = request.servletRequest().getRemoteAddr();
            }
            this.write(updated, X_FORWARDED_FOR_HEADER, remoteAddr, this.isForAppend(), this.trustedProxies::isTrusted);
        }
        String proto = request.uri().getScheme();
        if (this.isProtoEnabled()) {
            this.write(updated, X_FORWARDED_PROTO_HEADER, proto, this.isProtoAppend());
        }
        if (this.isPrefixEnabled()) {
            LinkedHashSet originalUris = (LinkedHashSet)MvcUtils.getAttribute(request, MvcUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
            URI requestUri = request.uri();
            if (originalUris != null && requestUri != null) {
                originalUris.forEach(originalUri -> {
                    if (originalUri != null && originalUri.getPath() != null) {
                        String originalUriPath = this.stripTrailingSlash((URI)originalUri);
                        String requestUriPath = this.stripTrailingSlash(requestUri);
                        this.updateRequest(updated, (URI)originalUri, originalUriPath, requestUriPath);
                    }
                });
            }
        }
        if (this.isPortEnabled()) {
            String port = String.valueOf(request.uri().getPort());
            if (request.uri().getPort() < 0) {
                port = String.valueOf(this.getDefaultPort(proto));
            }
            this.write(updated, X_FORWARDED_PORT_HEADER, port, this.isPortAppend());
        }
        if (this.isHostEnabled()) {
            String host = this.toHostHeader(request);
            this.write(updated, X_FORWARDED_HOST_HEADER, host, this.isHostAppend());
        }
        return updated;
    }

    private void updateRequest(HttpHeaders updated, URI originalUri, String originalUriPath, String requestUriPath) {
        String prefix;
        if (requestUriPath != null && originalUriPath.endsWith(requestUriPath) && (prefix = XForwardedRequestHeadersFilter.substringBeforeLast(originalUriPath, requestUriPath)) != null && prefix.length() > 0 && prefix.length() <= originalUri.getPath().length()) {
            this.write(updated, X_FORWARDED_PREFIX_HEADER, prefix, this.isPrefixAppend());
        }
    }

    private static String substringBeforeLast(String str, String separator) {
        if (ObjectUtils.isEmpty((Object)str) || ObjectUtils.isEmpty((Object)separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append) {
        this.write(headers, name, value, append, s -> true);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append, Predicate<String> shouldWrite) {
        if (append) {
            if (value != null) {
                headers.add(name, value);
            }
            if (headers.containsKey((Object)name)) {
                List<String> values = headers.get((Object)name).stream().filter(shouldWrite).toList();
                String delimitedValue = StringUtils.collectionToCommaDelimitedString(values);
                headers.set(name, delimitedValue);
            }
        } else if (value != null && shouldWrite.test(value)) {
            headers.set(name, value);
        }
    }

    private int getDefaultPort(String scheme) {
        return HTTPS_SCHEME.equals(scheme) ? 443 : 80;
    }

    private String toHostHeader(ServerRequest request) {
        int port = request.uri().getPort();
        String host = request.uri().getHost();
        String scheme = request.uri().getScheme();
        if (port < 0 || port == 80 && HTTP_SCHEME.equals(scheme) || port == 443 && HTTPS_SCHEME.equals(scheme)) {
            return host;
        }
        return host + ":" + port;
    }

    private String stripTrailingSlash(URI uri) {
        if (uri.getPath().endsWith("/")) {
            return uri.getPath().substring(0, uri.getPath().length() - 1);
        }
        return uri.getPath();
    }
}

