/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.gateway.server.mvc.common.Configurable;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcProperties;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcPropertiesBeanDefinitionRegistrar;
import org.springframework.cloud.gateway.server.mvc.config.NormalizedOperationMethod;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.cloud.gateway.server.mvc.filter.BeforeFilterFunctions;
import org.springframework.cloud.gateway.server.mvc.filter.FilterDiscoverer;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayRouterFunctions;
import org.springframework.cloud.gateway.server.mvc.handler.HandlerDiscoverer;
import org.springframework.cloud.gateway.server.mvc.invoke.InvocationContext;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationArgumentResolver;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameters;
import org.springframework.cloud.gateway.server.mvc.invoke.ParameterValueMapper;
import org.springframework.cloud.gateway.server.mvc.invoke.convert.ConversionServiceParameterValueMapper;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethod;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.ReflectiveOperationInvoker;
import org.springframework.cloud.gateway.server.mvc.predicate.PredicateDiscoverer;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;
import org.springframework.core.log.LogMessage;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.HandlerFunction;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public class RouterFunctionHolderFactory {
    private static final RequestPredicate neverPredicate = new RequestPredicate(){

        public boolean test(ServerRequest request) {
            return false;
        }

        public String toString() {
            return "Never";
        }
    };
    private static final RouterFunction<ServerResponse> NEVER_ROUTE = RouterFunctions.route((RequestPredicate)neverPredicate, request -> ServerResponse.notFound().build());
    private final Log log = LogFactory.getLog(this.getClass());
    private final TrueNullOperationArgumentResolver trueNullOperationArgumentResolver = new TrueNullOperationArgumentResolver();
    private final Environment env;
    private final FilterDiscoverer filterDiscoverer = new FilterDiscoverer();
    private final HandlerDiscoverer handlerDiscoverer = new HandlerDiscoverer();
    private final PredicateDiscoverer predicateDiscoverer = new PredicateDiscoverer();
    private final ParameterValueMapper parameterValueMapper = new ConversionServiceParameterValueMapper();

    public RouterFunctionHolderFactory(Environment env) {
        this.env = env;
    }

    private GatewayMvcPropertiesBeanDefinitionRegistrar.RouterFunctionHolder routerFunctionHolderSupplier() {
        RouterFunction routerFunction;
        GatewayMvcProperties properties = (GatewayMvcProperties)Binder.get((Environment)this.env).bindOrCreate("spring.cloud.gateway.mvc", GatewayMvcProperties.class);
        this.log.trace((Object)LogMessage.format((String)"RouterFunctionHolder initializing with %d map routes and %d list routes", (Object)properties.getRoutesMap().size(), (Object)properties.getRoutes().size()));
        LinkedHashMap routerFunctions = new LinkedHashMap();
        properties.getRoutes().forEach(routeProperties -> routerFunctions.put(routeProperties.getId(), this.getRouterFunction((RouteProperties)routeProperties, routeProperties.getId())));
        properties.getRoutesMap().forEach((routeId, routeProperties) -> {
            String computedRouteId = routeId;
            if (StringUtils.hasText((String)routeProperties.getId())) {
                computedRouteId = routeProperties.getId();
            }
            routerFunctions.put(computedRouteId, this.getRouterFunction((RouteProperties)routeProperties, computedRouteId));
        });
        if (routerFunctions.isEmpty()) {
            routerFunction = NEVER_ROUTE;
        } else {
            routerFunction = routerFunctions.values().stream().reduce(RouterFunction::andOther).orElse(null);
            routerFunction = routerFunction.withAttribute("gatewayRouterFunctions", routerFunctions);
        }
        this.log.trace((Object)LogMessage.format((String)"RouterFunctionHolder initialized %s", (Object)routerFunction.toString()));
        return new GatewayMvcPropertiesBeanDefinitionRegistrar.RouterFunctionHolder((RouterFunction<ServerResponse>)routerFunction);
    }

    private RouterFunction getRouterFunction(RouteProperties routeProperties, String routeId) {
        this.log.trace((Object)LogMessage.format((String)"Creating route for : %s", (Object)routeProperties));
        RouterFunctions.Builder builder = GatewayRouterFunctions.route(routeId);
        builder.filter((request, next) -> {
            MvcUtils.setRequestUrl(request, routeProperties.getUri());
            return next.handle(request);
        });
        builder.before(BeforeFilterFunctions.routeId(routeId));
        MultiValueMap<String, OperationMethod> handlerOperations = this.handlerDiscoverer.getOperations();
        String scheme = routeProperties.getUri().getScheme();
        HashMap<String, Object> handlerArgs = new HashMap<String, Object>();
        Optional<NormalizedOperationMethod> handlerOperationMethod = this.findOperation(handlerOperations, scheme.toLowerCase(Locale.ROOT), handlerArgs);
        if (handlerOperationMethod.isEmpty()) {
            handlerArgs.clear();
            String routePropsKey = StringUtils.uncapitalize((String)RouteProperties.class.getSimpleName());
            handlerArgs.put(routePropsKey, routeProperties);
            handlerOperationMethod = this.findOperation(handlerOperations, scheme.toLowerCase(Locale.ROOT), handlerArgs);
            if (handlerOperationMethod.isEmpty()) {
                throw new IllegalStateException("Unable to find HandlerFunction for scheme: " + scheme);
            }
        }
        NormalizedOperationMethod normalizedOpMethod = handlerOperationMethod.get();
        Object response = this.invokeOperation(normalizedOpMethod, normalizedOpMethod.getNormalizedArgs());
        HandlerFunction<ServerResponse> handlerFunction = null;
        ArrayList<HandlerFilterFunction<ServerResponse, ServerResponse>> handlerFilterFunctionFilters = new ArrayList<HandlerFilterFunction<ServerResponse, ServerResponse>>();
        if (response instanceof HandlerFunction) {
            handlerFunction = (HandlerFunction<ServerResponse>)response;
        } else if (response instanceof HandlerDiscoverer.Result) {
            HandlerDiscoverer.Result result = (HandlerDiscoverer.Result)response;
            handlerFunction = result.getHandlerFunction();
            handlerFilterFunctionFilters.addAll(result.getFilters());
        }
        if (handlerFunction == null) {
            throw new IllegalStateException("Unable to find HandlerFunction for scheme: " + scheme + " and response " + response);
        }
        MultiValueMap<String, OperationMethod> predicateOperations = this.predicateDiscoverer.getOperations();
        AtomicReference predicate = new AtomicReference();
        routeProperties.getPredicates().forEach(predicateProperties -> {
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>(predicateProperties.getArgs());
            this.translate(predicateOperations, predicateProperties.getName(), args, RequestPredicate.class, requestPredicate -> {
                this.log.trace((Object)LogMessage.format((String)"Adding predicate to route %s - %s", (Object)routeId, (Object)predicateProperties));
                if (predicate.get() == null) {
                    predicate.set(requestPredicate);
                } else {
                    RequestPredicate combined = ((RequestPredicate)predicate.get()).and(requestPredicate);
                    predicate.set(combined);
                }
                this.log.trace((Object)LogMessage.format((String)"Combined predicate for route %s - %s", (Object)routeId, predicate.get()));
            });
        });
        builder.route((RequestPredicate)predicate.get(), handlerFunction);
        predicate.set(null);
        MultiValueMap<String, OperationMethod> filterOperations = this.filterDiscoverer.getOperations();
        routeProperties.getFilters().forEach(filterProperties -> {
            LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>(filterProperties.getArgs());
            this.translate(filterOperations, filterProperties.getName(), args, HandlerFilterFunction.class, arg_0 -> ((RouterFunctions.Builder)builder).filter(arg_0));
        });
        handlerFilterFunctionFilters.forEach(arg_0 -> ((RouterFunctions.Builder)builder).filter(arg_0));
        builder.withAttribute(MvcUtils.GATEWAY_ROUTE_ID_ATTR, (Object)routeId);
        return builder.build();
    }

    private <T> void translate(MultiValueMap<String, OperationMethod> operations, String operationName, Map<String, Object> operationArgs, Class<T> returnType, Consumer<T> operationHandler) {
        String normalizedName = StringUtils.uncapitalize((String)operationName);
        Optional<NormalizedOperationMethod> operationMethod = this.findOperation(operations, normalizedName, operationArgs);
        if (operationMethod.isPresent()) {
            NormalizedOperationMethod opMethod = operationMethod.get();
            T handlerFilterFunction = this.invokeOperation(opMethod, opMethod.getNormalizedArgs());
            if (handlerFilterFunction != null) {
                operationHandler.accept(handlerFilterFunction);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)LogMessage.format((String)"Yaml Properties matched Operations name: %s, args: %s, params: %s", (Object)normalizedName, (Object)opMethod.getNormalizedArgs().toString(), (Object)Arrays.toString(opMethod.getParameters().stream().toArray())));
            }
        } else {
            throw new IllegalArgumentException(String.format("Unable to find operation %s for %s with args %s", returnType, normalizedName, operationArgs));
        }
    }

    private Optional<NormalizedOperationMethod> findOperation(MultiValueMap<String, OperationMethod> operations, String operationName, Map<String, Object> operationArgs) {
        return ((List)operations.getOrDefault((Object)operationName, Collections.emptyList())).stream().sorted(Comparator.comparing(OperationMethod::isConfigurable)).map(operationMethod -> new NormalizedOperationMethod((OperationMethod)operationMethod, operationArgs)).filter(opeMethod -> RouterFunctionHolderFactory.matchOperation(opeMethod, operationArgs)).findFirst();
    }

    private static boolean matchOperation(NormalizedOperationMethod operationMethod, Map<String, Object> args) {
        Map<String, Object> normalizedArgs = operationMethod.getNormalizedArgs();
        OperationParameters parameters = operationMethod.getParameters();
        if (operationMethod.isConfigurable()) {
            return true;
        }
        if (parameters.getParameterCount() != normalizedArgs.size()) {
            return false;
        }
        for (int i = 0; i < parameters.getParameterCount(); ++i) {
            if (normalizedArgs.containsKey(parameters.get(i).getName())) continue;
            return false;
        }
        return true;
    }

    private <T> T invokeOperation(OperationMethod operationMethod, Map<String, Object> operationArgs) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (operationMethod.isConfigurable()) {
            OperationParameter operationParameter = operationMethod.getParameters().get(0);
            Object config = RouterFunctionHolderFactory.bindConfigurable(operationMethod, operationArgs, operationParameter);
            args.put(operationParameter.getName(), config);
        } else {
            args.putAll(operationArgs);
        }
        ReflectiveOperationInvoker operationInvoker = new ReflectiveOperationInvoker(operationMethod, this.parameterValueMapper);
        InvocationContext context = new InvocationContext(args, this.trueNullOperationArgumentResolver);
        return operationInvoker.invoke(context);
    }

    private static Object bindConfigurable(OperationMethod operationMethod, Map<String, Object> args, OperationParameter operationParameter) {
        Class<?> configurableType = operationParameter.getType();
        Configurable configurable = operationMethod.getMethod().getAnnotation(Configurable.class);
        if (configurable != null && !configurable.value().equals(Void.class)) {
            configurableType = configurable.value();
        }
        Bindable bindable = Bindable.of(configurableType);
        List<MapConfigurationPropertySource> propertySources = Collections.singletonList(new MapConfigurationPropertySource(args));
        Binder binder = new Binder(propertySources, null, DefaultConversionService.getSharedInstance());
        Object config = binder.bindOrCreate("", bindable, (BindHandler)new IgnoreTopLevelConverterNotFoundBindHandler());
        return config;
    }

    static class TrueNullOperationArgumentResolver
    implements OperationArgumentResolver {
        TrueNullOperationArgumentResolver() {
        }

        @Override
        public boolean canResolve(Class<?> type) {
            return true;
        }

        @Override
        public <T> T resolve(Class<T> type) {
            return null;
        }
    }
}

