/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.mvc.ServletOutputToInputConverter;
import org.springframework.core.Conventions;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class ProxyExchange<T> {
    private @Nullable URI uri;
    private RestTemplate rest;
    private @Nullable Object body;
    private RequestResponseBodyMethodProcessor delegate;
    private NativeWebRequest webRequest;
    private ModelAndViewContainer mavContainer;
    private WebDataBinderFactory binderFactory;
    private @Nullable Set<String> excluded;
    private HttpHeaders headers = new HttpHeaders();
    private Type responseType;

    public ProxyExchange(RestTemplate rest, NativeWebRequest webRequest, ModelAndViewContainer mavContainer, WebDataBinderFactory binderFactory, Type type) {
        this.responseType = type;
        this.rest = rest;
        this.webRequest = webRequest;
        this.mavContainer = mavContainer;
        this.binderFactory = binderFactory;
        this.delegate = new RequestResponseBodyMethodProcessor(rest.getMessageConverters());
    }

    public ProxyExchange<T> body(Object body) {
        this.body = body;
        return this;
    }

    public ProxyExchange<T> header(String name, String ... value) {
        this.headers.put(name, Arrays.asList(value));
        return this;
    }

    public ProxyExchange<T> headers(HttpHeaders headers) {
        this.headers.putAll(headers);
        return this;
    }

    public ProxyExchange<T> excluded(String ... names) {
        if (this.excluded == null) {
            this.excluded = new HashSet<String>();
        }
        this.excluded.clear();
        for (String name : names) {
            this.excluded.add(name.toLowerCase(Locale.ROOT));
        }
        return this;
    }

    public ProxyExchange<T> uri(URI uri) {
        this.uri = uri;
        return this;
    }

    public ProxyExchange<T> uri(String uri) {
        try {
            return this.uri(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot create URI", e);
        }
    }

    public @Nullable String path() {
        return (String)this.webRequest.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE, 0);
    }

    public @Nullable String path(String prefix) {
        String path = this.path();
        if (path == null) {
            return null;
        }
        if (!path.startsWith(prefix)) {
            throw new IllegalArgumentException("Path does not start with prefix (" + prefix + "): " + path);
        }
        return path.substring(prefix.length());
    }

    public void forward(String path) {
        HttpServletRequest request = (HttpServletRequest)this.webRequest.getNativeRequest(HttpServletRequest.class);
        HttpServletResponse response = (HttpServletResponse)this.webRequest.getNativeResponse(HttpServletResponse.class);
        try {
            Objects.requireNonNull(request, "HttpServletRequest is required");
            Objects.requireNonNull(response, "HttpServletResponse is required");
            request.getRequestDispatcher(path).forward((ServletRequest)new BodyForwardingHttpServletRequest(request, response), (ServletResponse)response);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot forward request", e);
        }
    }

    public ResponseEntity<T> get() {
        Objects.requireNonNull(this.uri, "URI is required");
        Object body = this.body();
        RequestEntity.BodyBuilder builder = this.headers((RequestEntity.BodyBuilder)RequestEntity.get((URI)this.uri));
        if (body != null) {
            return this.exchange(builder.body(body));
        }
        return this.exchange(builder.build());
    }

    public <S> ResponseEntity<S> get(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.get());
    }

    public ResponseEntity<T> head() {
        Objects.requireNonNull(this.uri, "URI is required");
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.head((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> head(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.head());
    }

    public ResponseEntity<T> options() {
        Objects.requireNonNull(this.uri, "URI is required");
        RequestEntity requestEntity = this.headers((RequestEntity.BodyBuilder)RequestEntity.options((URI)this.uri)).build();
        return this.exchange(requestEntity);
    }

    public <S> ResponseEntity<S> options(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.options());
    }

    public ResponseEntity<T> post() {
        Objects.requireNonNull(this.uri, "URI is required");
        Object body = this.body();
        RequestEntity.BodyBuilder builder = this.headers(RequestEntity.post((URI)this.uri));
        if (body != null) {
            return this.exchange(builder.body(body));
        }
        return this.exchange(builder.build());
    }

    public <S> ResponseEntity<S> post(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.post());
    }

    public ResponseEntity<T> delete() {
        Objects.requireNonNull(this.uri, "URI is required");
        Object body = this.body();
        RequestEntity.BodyBuilder builder = this.headers((RequestEntity.BodyBuilder)RequestEntity.delete((URI)this.uri));
        if (body != null) {
            return this.exchange(builder.body(body));
        }
        return this.exchange(builder.build());
    }

    public <S> ResponseEntity<S> delete(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.delete());
    }

    public ResponseEntity<T> put() {
        Objects.requireNonNull(this.uri, "URI is required");
        Object body = this.body();
        RequestEntity.BodyBuilder builder = this.headers(RequestEntity.put((URI)this.uri));
        if (body != null) {
            return this.exchange(builder.body(body));
        }
        return this.exchange(builder.build());
    }

    public <S> ResponseEntity<S> put(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.put());
    }

    public ResponseEntity<T> patch() {
        Objects.requireNonNull(this.uri, "URI is required");
        Object body = this.body();
        RequestEntity.BodyBuilder builder = this.headers(RequestEntity.patch((URI)this.uri));
        if (body != null) {
            return this.exchange(builder.body(body));
        }
        return this.exchange(builder.build());
    }

    public <S> ResponseEntity<S> patch(Function<ResponseEntity<T>, ResponseEntity<S>> converter) {
        return converter.apply(this.patch());
    }

    private ResponseEntity<T> exchange(RequestEntity<?> requestEntity) {
        Object type = this.responseType;
        if (type instanceof TypeVariable || type instanceof WildcardType) {
            type = Object.class;
        }
        return this.rest.exchange(requestEntity, ParameterizedTypeReference.forType((Type)type));
    }

    private void addHeaders(HttpHeaders headers) {
        ArrayList<String> headerNames = new ArrayList<String>();
        this.webRequest.getHeaderNames().forEachRemaining(headerNames::add);
        Set<String> filteredKeys = this.filterHeaderKeys(headerNames);
        filteredKeys.stream().filter(key -> !headers.containsHeader(key)).forEach(header -> headers.addAll(header, Arrays.asList(this.webRequest.getHeaderValues(header))));
    }

    private RequestEntity.BodyBuilder headers(RequestEntity.BodyBuilder builder) {
        this.proxy();
        for (String name : this.filterHeaderKeys(this.headers)) {
            List values = this.headers.get(name);
            if (values == null) continue;
            builder.header(name, values.toArray(new String[0]));
        }
        builder.headers(this::addHeaders);
        return builder;
    }

    private Set<String> filterHeaderKeys(HttpHeaders headers) {
        return this.filterHeaderKeys(headers.headerNames());
    }

    private Set<String> filterHeaderKeys(Collection<String> headerNames) {
        Set<Object> excludedHeaders = this.excluded != null ? this.excluded : Collections.emptySet();
        return headerNames.stream().filter(header -> !excludedHeaders.contains(header.toLowerCase(Locale.ROOT))).collect(Collectors.toSet());
    }

    private void proxy() {
        HttpServletRequest request = (HttpServletRequest)this.webRequest.getNativeRequest(HttpServletRequest.class);
        Objects.requireNonNull(request, "Request is required");
        try {
            URI uri = new URI(request.getRequestURL().toString());
            this.appendForwarded(uri);
            this.appendXForwarded(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Cannot create URI for request: " + String.valueOf(request.getRequestURL()));
        }
    }

    private void appendXForwarded(URI uri) {
        Object host = this.headers.getFirst("x-forwarded-host");
        if (host == null) {
            return;
        }
        host = (String)host + "," + uri.getHost();
        this.headers.set("x-forwarded-host", (String)host);
        Object proto = this.headers.getFirst("x-forwarded-proto");
        if (proto == null) {
            return;
        }
        proto = (String)proto + "," + uri.getScheme();
        this.headers.set("x-forwarded-proto", (String)proto);
    }

    private void appendForwarded(URI uri) {
        Object forwarded = this.headers.getFirst("forwarded");
        forwarded = forwarded != null ? (String)forwarded + "," : "";
        String forwardedHeader = this.webRequest.getHeader("host");
        if (forwardedHeader != null) {
            forwarded = (String)forwarded + this.forwarded(uri, forwardedHeader);
        }
        this.headers.set("forwarded", (String)forwarded);
    }

    private String forwarded(URI uri, String hostHeader) {
        if (StringUtils.hasText((String)hostHeader)) {
            return "host=" + hostHeader;
        }
        if ("http".equals(uri.getScheme())) {
            return "host=" + uri.getHost();
        }
        return String.format("host=%s;proto=%s", uri.getHost(), uri.getScheme());
    }

    private @Nullable Object body() {
        if (this.body != null) {
            return this.body;
        }
        this.body = this.getRequestBody();
        return this.body;
    }

    private @Nullable Object getRequestBody() {
        for (String key : this.mavContainer.getModel().keySet()) {
            if (!key.startsWith(BindingResult.MODEL_KEY_PREFIX)) continue;
            BindingResult result = (BindingResult)this.mavContainer.getModel().get((Object)key);
            return result.getTarget();
        }
        MethodParameter input = new MethodParameter(ClassUtils.getMethod(BodyGrabber.class, (String)"body", (Class[])new Class[]{Object.class}), 0);
        try {
            this.delegate.resolveArgument(input, this.mavContainer, this.webRequest, this.binderFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot resolve body", e);
        }
        String name = Conventions.getVariableNameForParameter((MethodParameter)input);
        BindingResult result = (BindingResult)this.mavContainer.getModel().get((Object)(BindingResult.MODEL_KEY_PREFIX + name));
        if (result == null) {
            return null;
        }
        return result.getTarget();
    }

    class BodyForwardingHttpServletRequest
    extends HttpServletRequestWrapper {
        private HttpServletRequest request;
        private HttpServletResponse response;

        BodyForwardingHttpServletRequest(HttpServletRequest request, HttpServletResponse response) {
            super(request);
            this.request = request;
            this.response = response;
        }

        private @Nullable List<String> header(String name) {
            return ProxyExchange.this.headers.get(name);
        }

        public ServletInputStream getInputStream() throws IOException {
            Object body = ProxyExchange.this.body();
            MethodParameter output = new MethodParameter(ClassUtils.getMethod(BodySender.class, (String)"body", (Class[])new Class[0]), -1);
            ServletOutputToInputConverter response = new ServletOutputToInputConverter(this.response);
            ServletWebRequest webRequest = new ServletWebRequest(this.request, (HttpServletResponse)response);
            try {
                ProxyExchange.this.delegate.handleReturnValue(body, output, ProxyExchange.this.mavContainer, (NativeWebRequest)webRequest);
            }
            catch (HttpMessageNotWritableException | HttpMediaTypeNotAcceptableException e) {
                throw new IllegalStateException("Cannot convert body", e);
            }
            return response.getInputStream();
        }

        public Enumeration<String> getHeaderNames() {
            Set names = ProxyExchange.this.headers.headerNames();
            if (names.isEmpty()) {
                return super.getHeaderNames();
            }
            LinkedHashSet result = new LinkedHashSet(names);
            result.addAll(Collections.list(super.getHeaderNames()));
            return new Vector(result).elements();
        }

        public Enumeration<String> getHeaders(String name) {
            List<String> list = this.header(name);
            if (list != null) {
                return new Vector<String>(list).elements();
            }
            return super.getHeaders(name);
        }

        public String getHeader(String name) {
            List<String> list = this.header(name);
            if (list != null && !list.isEmpty()) {
                return list.iterator().next();
            }
            return super.getHeader(name);
        }
    }

    protected static class BodyGrabber {
        protected BodyGrabber() {
        }

        public Object body(@RequestBody(required=false) Object body) {
            return body;
        }
    }

    protected static class BodySender {
        protected BodySender() {
        }

        @ResponseBody
        public @Nullable Object body() {
            return null;
        }
    }
}

