/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc.config;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.cloud.gateway.mvc.config.ProxyExchangeArgumentResolver;
import org.springframework.cloud.gateway.mvc.config.ProxyExchangeWebMvcProperties;
import org.springframework.cloud.gateway.mvc.config.ProxyProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication
@ConditionalOnClass(value={HandlerMethodReturnValueHandler.class})
@EnableConfigurationProperties(value={ProxyExchangeWebMvcProperties.class, ProxyProperties.class})
public class ProxyResponseAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private ApplicationContext context;

    @Bean
    @ConditionalOnMissingBean
    public ProxyExchangeArgumentResolver proxyExchangeArgumentResolver(Optional<RestTemplateBuilder> optional, ProxyExchangeWebMvcProperties properties) {
        RestTemplateBuilder builder = optional.orElse(new RestTemplateBuilder(new RestTemplateCustomizer[0]));
        RestTemplate template = builder.build();
        template.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
        template.getMessageConverters().add(new ByteArrayHttpMessageConverter(){

            public boolean supports(Class<?> clazz) {
                return true;
            }
        });
        ProxyExchangeArgumentResolver resolver = new ProxyExchangeArgumentResolver(template);
        resolver.setHeaders(properties.convertHeaders());
        resolver.setAutoForwardedHeaders(properties.getAutoForward());
        HashSet<String> excludedHeaderNames = new HashSet<String>();
        if (properties.getSensitive() != null) {
            excludedHeaderNames.addAll(properties.getSensitive());
        }
        if (properties.getSkipped() != null) {
            excludedHeaderNames.addAll(properties.getSkipped());
        }
        resolver.setExcluded(excludedHeaderNames);
        return resolver;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)this.context.getBean(ProxyExchangeArgumentResolver.class));
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
        }

        public void handleError(URI url, HttpMethod method, ClientHttpResponse response) throws IOException {
        }

        protected void handleError(ClientHttpResponse response, HttpStatusCode statusCode, URI url, HttpMethod method) throws IOException {
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingClass(value={"org.springframework.cloud.gateway.proxyexchange.webmvc.Marker"})
    protected static class NewModuleConfiguration {
        private static final Log log = LogFactory.getLog(ProxyResponseAutoConfiguration.class);
        private static final String BORDER = "\n\n**********************************************************\n\n";

        public NewModuleConfiguration() {
            log.warn((Object)"\n\n**********************************************************\n\nThe artifact spring-cloud-gateway-mvc is deprecated. It will be removed in the next major release. Please add spring-cloud-gateway-proxyexchange-webmvc dependency.\n\n**********************************************************\n\n");
        }
    }
}

