/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.mvc.config;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpHeaders;

@ConfigurationProperties(value="spring.cloud.gateway.proxy")
public class ProxyProperties {
    public static Set<String> DEFAULT_SENSITIVE = Set.of("cookie", "authorization");
    public static Set<String> DEFAULT_SKIPPED = Set.of("content-length", "host");
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private Set<String> autoForward = new HashSet<String>();
    private Set<String> sensitive = DEFAULT_SENSITIVE;
    private Set<String> skipped = DEFAULT_SKIPPED;

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Set<String> getAutoForward() {
        return this.autoForward;
    }

    public void setAutoForward(Set<String> autoForward) {
        this.autoForward = autoForward;
    }

    public Set<String> getSensitive() {
        return this.sensitive;
    }

    public void setSensitive(Set<String> sensitive) {
        this.sensitive = sensitive;
    }

    public Set<String> getSkipped() {
        return this.skipped;
    }

    public void setSkipped(Set<String> skipped) {
        this.skipped = skipped;
    }

    public HttpHeaders convertHeaders() {
        HttpHeaders headers = new HttpHeaders();
        for (String key : this.headers.keySet()) {
            headers.set(key, this.headers.get(key));
        }
        return headers;
    }
}

