/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.boot.web.server.servlet.ServletWebServerFactory;
import org.springframework.boot.web.server.servlet.context.ServletWebServerApplicationContext;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletContextInitializerBeans;
import org.springframework.cloud.function.serverless.web.ServerlessMVC;
import org.springframework.cloud.function.serverless.web.ServerlessServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration(proxyBeanMethods=false)
public class ServerlessAutoConfiguration {
    private static Log logger = LogFactory.getLog(ServerlessAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ServletWebServerFactory servletWebServerFactory() {
        return new ServerlessServletWebServerFactory();
    }

    public static class ServerlessServletWebServerFactory
    implements ServletWebServerFactory,
    ApplicationContextAware,
    InitializingBean {
        private ApplicationContext applicationContext;

        public WebServer getWebServer(ServletContextInitializer ... initializers) {
            return new WebServer(){

                public void stop() throws WebServerException {
                }

                public void start() throws WebServerException {
                }

                public int getPort() {
                    return 0;
                }
            };
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public void afterPropertiesSet() throws Exception {
            ApplicationContext applicationContext = this.applicationContext;
            if (applicationContext instanceof ServletWebServerApplicationContext) {
                ServletWebServerApplicationContext servletApplicationContext = (ServletWebServerApplicationContext)applicationContext;
                logger.info((Object)"Configuring Serverless Web Container");
                ServerlessServletContext servletContext = new ServerlessServletContext();
                servletApplicationContext.setServletContext((ServletContext)servletContext);
                DispatcherServlet dispatcher = (DispatcherServlet)this.applicationContext.getBean(DispatcherServlet.class);
                try {
                    logger.info((Object)"Initializing DispatcherServlet");
                    dispatcher.init((ServletConfig)new ServerlessMVC.ProxyServletConfig(servletApplicationContext.getServletContext()));
                    logger.info((Object)"Initialized DispatcherServlet");
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to create Spring MVC DispatcherServlet proxy", e);
                }
                for (ServletContextInitializer initializer : new ServletContextInitializerBeans((ListableBeanFactory)this.applicationContext, new Class[0])) {
                    initializer.onStartup((ServletContext)servletContext);
                }
            } else {
                logger.debug((Object)("Skipping Serverless configuration for " + String.valueOf(this.applicationContext)));
            }
        }
    }
}

