/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletSecurityElement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ServerlessServletRegistration
implements ServletRegistration,
ServletRegistration.Dynamic,
Comparable<ServerlessServletRegistration> {
    private final String servletName;
    private final Servlet servlet;
    private final ServletContext servletContext;
    private int loadOnStartup;

    public ServerlessServletRegistration(String servletName, Servlet servlet, ServletContext servletContext) {
        this.servlet = servlet;
        this.servletName = servletName;
        this.servletContext = servletContext;
    }

    public String getName() {
        return this.servletName;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getClassName() {
        if (this.servlet != null) {
            return this.servletName.getClass().getName();
        }
        return null;
    }

    public boolean setInitParameter(String name, String value) {
        return false;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        return null;
    }

    public Map<String, String> getInitParameters() {
        return null;
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
    }

    public void setLoadOnStartup(int loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public Set<String> setServletSecurity(ServletSecurityElement constraint) {
        return null;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfig) {
    }

    public void setRunAsRole(String roleName) {
    }

    public Set<String> addMapping(String ... urlPatterns) {
        return null;
    }

    public Collection<String> getMappings() {
        return null;
    }

    public String getRunAsRole() {
        return null;
    }

    @Override
    public int compareTo(ServerlessServletRegistration o) {
        return Integer.compare(this.loadOnStartup, o.getLoadOnStartup());
    }
}

