/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.cloud.function.serverless.web.ServerlessAsyncContext;
import org.springframework.cloud.function.serverless.web.ServerlessFilterRegistration;
import org.springframework.cloud.function.serverless.web.ServerlessHttpServletRequest;
import org.springframework.cloud.function.serverless.web.ServerlessHttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public final class ServerlessMVC {
    public static String INIT_TIMEOUT = "contextInitTimeout";
    private static Log LOG = LogFactory.getLog(ServerlessMVC.class);
    private volatile DispatcherServlet dispatcher;
    private volatile ServletWebServerApplicationContext applicationContext;
    private ServletContext servletContext;
    private final CountDownLatch contextStartupLatch = new CountDownLatch(1);
    private final long initializatioinTimeout;

    public static ServerlessMVC INSTANCE(Class<?> ... componentClasses) {
        ServerlessMVC mvc = new ServerlessMVC();
        mvc.initializeContextAsync(componentClasses);
        return mvc;
    }

    public static ServerlessMVC INSTANCE(ServletWebServerApplicationContext applicationContext) {
        ServerlessMVC mvc = new ServerlessMVC();
        mvc.applicationContext = applicationContext;
        mvc.dispatcher = (DispatcherServlet)mvc.applicationContext.getBean(DispatcherServlet.class);
        mvc.contextStartupLatch.countDown();
        return mvc;
    }

    private ServerlessMVC() {
        String timeoutValue = System.getenv(INIT_TIMEOUT);
        if (!StringUtils.hasText((String)timeoutValue)) {
            timeoutValue = System.getProperty(INIT_TIMEOUT);
        }
        this.initializatioinTimeout = StringUtils.hasText((String)timeoutValue) ? Long.valueOf(timeoutValue) : 20000L;
    }

    private void initializeContextAsync(Class<?> ... componentClasses) {
        new Thread(() -> {
            try {
                LOG.info((Object)"Starting application with the following configuration classes:");
                Stream.of(componentClasses).forEach(clazz -> LOG.info((Object)clazz.getSimpleName()));
                this.initContext(componentClasses);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.contextStartupLatch.countDown();
                LOG.info((Object)"Application is started successfully.");
            }
        }).start();
    }

    private void initContext(Class<?> ... componentClasses) {
        this.applicationContext = (ServletWebServerApplicationContext)SpringApplication.run((Class[])componentClasses, (String[])new String[0]);
        if (this.applicationContext.containsBean("dispatcherServlet")) {
            this.dispatcher = (DispatcherServlet)this.applicationContext.getBean(DispatcherServlet.class);
        }
    }

    public ConfigurableWebApplicationContext getApplicationContext() {
        this.waitForContext();
        return this.applicationContext;
    }

    public ServletContext getServletContext() {
        this.waitForContext();
        return this.servletContext;
    }

    public void stop() {
        this.waitForContext();
        this.applicationContext.stop();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Assert.state((boolean)this.waitForContext(), (String)("Failed to initialize Application within the specified time of " + this.initializatioinTimeout + " milliseconds. If you need to increase it, please set " + INIT_TIMEOUT + " environment variable"));
        this.service(request, response, null);
    }

    public void service(HttpServletRequest request, HttpServletResponse response, CountDownLatch latch) throws Exception {
        ProxyFilterChain filterChain = new ProxyFilterChain(this.dispatcher);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        AsyncContext asyncContext = request.getAsyncContext();
        if (asyncContext != null) {
            filterChain = new ProxyFilterChain(this.dispatcher);
            if (asyncContext instanceof ServerlessAsyncContext) {
                ServerlessAsyncContext proxyAsyncContext = (ServerlessAsyncContext)asyncContext;
                proxyAsyncContext.addDispatchHandler(() -> {
                    try {
                        new ProxyFilterChain(this.dispatcher).doFilter((ServletRequest)request, (ServletResponse)response);
                        asyncContext.complete();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
        }
        if (latch != null) {
            latch.countDown();
        }
    }

    public boolean waitForContext() {
        try {
            return this.contextStartupLatch.await(this.initializatioinTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private static class ProxyFilterChain
    implements FilterChain {
        @Nullable
        private ServletRequest request;
        @Nullable
        private ServletResponse response;
        private final List<Filter> filters;
        @Nullable
        private Iterator<Filter> iterator;

        ProxyFilterChain(DispatcherServlet servlet) {
            ArrayList filters = new ArrayList();
            servlet.getServletContext().getFilterRegistrations().values().forEach(fr -> filters.add(((ServerlessFilterRegistration)fr).getFilter()));
            Assert.notNull(filters, (String)"filters cannot be null");
            Assert.noNullElements(filters, (String)"filters cannot contain null values");
            this.filters = ProxyFilterChain.initFilterList((Servlet)servlet, filters.toArray(new Filter[0]));
        }

        private static List<Filter> initFilterList(Servlet servlet, Filter ... filters) {
            Filter[] allFilters = (Filter[])ObjectUtils.addObjectToArray((Object[])filters, (Object)new ServletFilterProxy(servlet));
            return Arrays.asList(allFilters);
        }

        @Nullable
        public ServletRequest getRequest() {
            return this.request;
        }

        @Nullable
        public ServletResponse getResponse() {
            return this.response;
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            Assert.notNull((Object)request, (String)"Request must not be null");
            Assert.notNull((Object)response, (String)"Response must not be null");
            Assert.state((this.request == null ? 1 : 0) != 0, (String)"This FilterChain has already been called!");
            if (this.iterator == null) {
                this.iterator = this.filters.iterator();
            }
            if (this.iterator.hasNext()) {
                Filter nextFilter = this.iterator.next();
                nextFilter.doFilter(request, response, (FilterChain)this);
            }
            this.request = request;
            this.response = response;
        }

        private static final class ServletFilterProxy
        implements Filter {
            private final Servlet delegateServlet;

            private ServletFilterProxy(Servlet servlet) {
                Assert.notNull((Object)servlet, (String)"servlet cannot be null");
                this.delegateServlet = servlet;
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                try {
                    if (((HttpServletResponse)response).getStatus() != HttpStatus.OK.value() && request instanceof ServerlessHttpServletRequest) {
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.status_code", (Object)((HttpServletResponse)response).getStatus());
                        this.setErrorMessageAttribute((ServerlessHttpServletRequest)request, (ServerlessHttpServletResponse)response, null);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)request).getRequestURI());
                        ((ServerlessHttpServletRequest)request).setRequestURI("/error");
                        this.delegateServlet.service(request, response);
                    } else {
                        this.delegateServlet.service(request, response);
                    }
                }
                catch (Exception e) {
                    if (request instanceof ServerlessHttpServletRequest) {
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.status_code", (Object)HttpStatus.INTERNAL_SERVER_ERROR.value());
                        this.setErrorMessageAttribute((HttpServletRequest)request, (HttpServletResponse)response, e);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.exception_type", (Object)e);
                        ((HttpServletRequest)request).setAttribute("jakarta.servlet.error.request_uri", (Object)((HttpServletRequest)request).getRequestURI());
                        ((ServerlessHttpServletRequest)request).setRequestURI("/error");
                    }
                    LOG.error((Object)("Failed processing the request to: " + ((HttpServletRequest)request).getRequestURI()), (Throwable)e);
                    this.delegateServlet.service(request, response);
                }
            }

            private void setErrorMessageAttribute(HttpServletRequest request, HttpServletResponse response, Exception exception) {
                ServerlessHttpServletResponse proxyResponse;
                if (exception != null && StringUtils.hasText((String)exception.getMessage())) {
                    request.setAttribute("jakarta.servlet.error.message", (Object)exception.getMessage());
                } else if (response instanceof ServerlessHttpServletResponse && StringUtils.hasText((String)(proxyResponse = (ServerlessHttpServletResponse)response).getErrorMessage())) {
                    request.setAttribute("jakarta.servlet.error.message", (Object)proxyResponse.getErrorMessage());
                } else {
                    request.setAttribute("jakarta.servlet.error.message", (Object)HttpStatus.valueOf((int)response.getStatus()).getReasonPhrase());
                }
            }

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void destroy() {
            }

            public String toString() {
                return this.delegateServlet.toString();
            }
        }
    }

    public static class ProxyServletConfig
    implements ServletConfig {
        private final ServletContext servletContext;

        public ProxyServletConfig(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        public String getServletName() {
            return "dispatcherServlet";
        }

        public ServletContext getServletContext() {
            return this.servletContext;
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(new ArrayList());
        }

        public String getInitParameter(String name) {
            return null;
        }
    }
}

