/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.serverless.web;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletRegistrationBean;
import org.springframework.boot.web.context.ConfigurableWebServerApplicationContext;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletContextInitializerBeans;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.cloud.function.serverless.web.ServerlessMVC;
import org.springframework.cloud.function.serverless.web.ServerlessServletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration(proxyBeanMethods=false)
public class ServerlessAutoConfiguration {
    private static Log logger = LogFactory.getLog(ServerlessAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ServletWebServerFactory servletWebServerFactory() {
        return new ServerlessServletWebServerFactory();
    }

    private static class ServerlessServletWebServerFactory
    implements ServletWebServerFactory,
    ApplicationContextAware,
    InitializingBean {
        private ConfigurableWebServerApplicationContext applicationContext;

        private ServerlessServletWebServerFactory() {
        }

        public WebServer getWebServer(ServletContextInitializer ... initializers) {
            return new WebServer(){

                public void stop() throws WebServerException {
                }

                public void start() throws WebServerException {
                    ConfigurableWebServerApplicationContext configurableWebServerApplicationContext = applicationContext;
                    if (configurableWebServerApplicationContext instanceof ServletWebServerApplicationContext) {
                        ServletWebServerApplicationContext servletApplicationContet = (ServletWebServerApplicationContext)configurableWebServerApplicationContext;
                        DispatcherServlet dispatcher = (DispatcherServlet)applicationContext.getBean(DispatcherServlet.class);
                        try {
                            dispatcher.init((ServletConfig)new ServerlessMVC.ProxyServletConfig(servletApplicationContet.getServletContext()));
                            logger.info((Object)"Initalized DispatcherServlet");
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Faild to create Spring MVC DispatcherServlet proxy", e);
                        }
                    }
                }

                public int getPort() {
                    return 0;
                }
            };
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = (ConfigurableWebServerApplicationContext)applicationContext;
        }

        public void afterPropertiesSet() throws Exception {
            ConfigurableWebServerApplicationContext configurableWebServerApplicationContext = this.applicationContext;
            if (configurableWebServerApplicationContext instanceof ServletWebServerApplicationContext) {
                ServletWebServerApplicationContext servletApplicationContet = (ServletWebServerApplicationContext)configurableWebServerApplicationContext;
                logger.info((Object)"Configuring Serverless Web Container");
                ServerlessServletContext servletContext = new ServerlessServletContext();
                servletApplicationContet.setServletContext((ServletContext)servletContext);
                for (ServletContextInitializer beans : new ServletContextInitializerBeans((ListableBeanFactory)this.applicationContext, new Class[0])) {
                    if (beans instanceof DispatcherServletRegistrationBean) continue;
                    beans.onStartup((ServletContext)servletContext);
                }
            }
        }
    }
}

