/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.rsocket.messaging.RSocketStrategiesCustomizer;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.rsocket.MessageAwareJsonDecoder;
import org.springframework.cloud.function.rsocket.MessageAwareJsonEncoder;
import org.springframework.cloud.function.rsocket.RSocketFunctionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.rsocket.RSocketStrategies;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FunctionProperties.class, RSocketFunctionProperties.class})
public class RSocketCustomizerConfiguration {
    @Bean
    RSocketStrategiesCustomizer rSocketStrategiesCustomizer(final JsonMapper jsonMapper) {
        return new RSocketStrategiesCustomizer(){

            public void customize(RSocketStrategies.Builder strategies) {
                strategies.encoders(encoders -> encoders.add(0, new MessageAwareJsonEncoder(jsonMapper, true))).decoders(decoders -> decoders.add(0, new MessageAwareJsonDecoder(jsonMapper)));
            }
        };
    }
}

