/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.rsocket.RSocketMessageHandlerCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.rsocket.FunctionRSocketMessageHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FunctionProperties.class})
@ConditionalOnProperty(name={"spring.cloud.function.rsocket.enabled"}, matchIfMissing=true)
class RSocketAutoConfiguration {
    RSocketAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @Primary
    FunctionRSocketMessageHandler functionRSocketMessageHandler(RSocketStrategies rSocketStrategies, ObjectProvider<RSocketMessageHandlerCustomizer> customizers, FunctionCatalog functionCatalog, FunctionProperties functionProperties, JsonMapper jsonMapper) {
        FunctionRSocketMessageHandler rsocketMessageHandler = new FunctionRSocketMessageHandler(functionCatalog, functionProperties, jsonMapper);
        rsocketMessageHandler.setRSocketStrategies(rSocketStrategies);
        customizers.orderedStream().forEach(customizer -> customizer.customize((RSocketMessageHandler)rsocketMessageHandler));
        return rsocketMessageHandler;
    }
}

