/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.rsocket;

import io.rsocket.frame.FrameType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionProperties;
import org.springframework.cloud.function.context.MessageRoutingCallback;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.rsocket.FunctionRSocketUtils;
import org.springframework.cloud.function.rsocket.MessageAwareJsonEncoder;
import org.springframework.cloud.function.rsocket.RSocketListenerFunction;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.handler.CompositeMessageCondition;
import org.springframework.messaging.handler.DestinationPatternsMessageCondition;
import org.springframework.messaging.handler.MessageCondition;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodReturnValueHandler;
import org.springframework.messaging.handler.invocation.reactive.SyncHandlerMethodArgumentResolver;
import org.springframework.messaging.rsocket.DefaultMetadataExtractor;
import org.springframework.messaging.rsocket.MetadataExtractor;
import org.springframework.messaging.rsocket.annotation.support.RSocketFrameTypeMessageCondition;
import org.springframework.messaging.rsocket.annotation.support.RSocketMessageHandler;
import org.springframework.messaging.rsocket.annotation.support.RSocketPayloadReturnValueHandler;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.RouteMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.util.pattern.PathPatternRouteMatcher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class FunctionRSocketMessageHandler
extends RSocketMessageHandler {
    public static final String RECONCILED_LOOKUP_DESTINATION_HEADER = "reconciledLookupDestination";
    private final FunctionCatalog functionCatalog;
    private final FunctionProperties functionProperties;
    private final Field headersField;
    private final JsonMapper jsonMapper;
    private static final Method FUNCTION_APPLY_METHOD = ReflectionUtils.findMethod(Function.class, (String)"apply", (Class[])null);
    private static final RSocketFrameTypeMessageCondition REQUEST_CONDITION = new RSocketFrameTypeMessageCondition(new FrameType[]{FrameType.REQUEST_FNF, FrameType.REQUEST_RESPONSE, FrameType.REQUEST_STREAM, FrameType.REQUEST_CHANNEL});

    FunctionRSocketMessageHandler(FunctionCatalog functionCatalog, FunctionProperties functionProperties, JsonMapper jsonMapper) {
        this.setHandlerPredicate(clazz -> false);
        this.functionCatalog = functionCatalog;
        this.functionProperties = functionProperties;
        this.headersField = ReflectionUtils.findField(MessageHeaders.class, (String)"headers");
        this.headersField.setAccessible(true);
        this.jsonMapper = jsonMapper;
    }

    public void afterPropertiesSet() {
        List encoders = this.getEncoders();
        encoders.set(0, new MessageAwareJsonEncoder(this.jsonMapper));
        super.afterPropertiesSet();
    }

    public MetadataExtractor getMetadataExtractor() {
        return new HeadersAwareMetadataExtractor(this.getDecoders());
    }

    public Mono<Void> handleMessage(Message<?> message) throws MessagingException {
        if (!FrameType.SETUP.equals(message.getHeaders().get((Object)"rsocketFrameType"))) {
            String destination = this.discoverAndInjectDestinationHeader(message);
            Set mappings = this.getDestinationLookup().keySet();
            if (!mappings.contains(destination)) {
                SimpleFunctionRegistry.FunctionInvocationWrapper function = FunctionRSocketUtils.registerFunctionForDestination(destination, this.functionCatalog, this.getApplicationContext());
                this.registerFunctionHandler(new RSocketListenerFunction(function), destination);
            }
        }
        return super.handleMessage(message);
    }

    protected RouteMatcher.Route getDestination(Message<?> message) {
        RouteMatcher.Route reconsiledDestination = (RouteMatcher.Route)message.getHeaders().get((Object)RECONCILED_LOOKUP_DESTINATION_HEADER);
        return reconsiledDestination == null ? super.getDestination(message) : reconsiledDestination;
    }

    protected CompositeMessageCondition getMatchingMapping(CompositeMessageCondition mapping, Message<?> message) {
        ArrayList<MessageCondition> result = new ArrayList<MessageCondition>(mapping.getMessageConditions().size());
        for (MessageCondition condition : mapping.getMessageConditions()) {
            MessageCondition matchingCondition;
            MessageCondition messageCondition = matchingCondition = condition instanceof DestinationPatternsMessageCondition ? condition : (MessageCondition)condition.getMatchingCondition(message);
            if (matchingCondition == null) {
                return null;
            }
            result.add(matchingCondition);
        }
        return new CompositeMessageCondition(result.toArray(new MessageCondition[0]));
    }

    void registerFunctionHandler(Function<?, ?> function, String route) {
        CompositeMessageCondition condition = new CompositeMessageCondition(new MessageCondition[]{REQUEST_CONDITION, new DestinationPatternsMessageCondition(new String[]{route}, this.obtainRouteMatcher())});
        this.registerHandlerMethod(function, FUNCTION_APPLY_METHOD, condition);
    }

    protected List<? extends HandlerMethodArgumentResolver> initArgumentResolvers() {
        List resolvers = super.initArgumentResolvers();
        return Collections.singletonList(new MessageHandlerMethodArgumentResolver(this.jsonMapper, resolvers));
    }

    protected List<? extends HandlerMethodReturnValueHandler> initReturnValueHandlers() {
        return Collections.singletonList(new FunctionRSocketPayloadReturnValueHandler(this.getEncoders(), this.getReactiveAdapterRegistry()));
    }

    private String discoverAndInjectDestinationHeader(Message<?> message) {
        String destination;
        if (!CollectionUtils.isEmpty((Map)this.getApplicationContext().getBeansOfType(MessageRoutingCallback.class))) {
            destination = "functionRouter";
        } else if (StringUtils.hasText((String)this.functionProperties.getRoutingExpression())) {
            destination = "functionRouter";
            this.updateMessageHeaders(message, destination);
        } else {
            RouteMatcher.Route route = (RouteMatcher.Route)message.getHeaders().get((Object)"lookupDestination");
            destination = route.value();
            if (!StringUtils.hasText((String)destination)) {
                destination = this.functionProperties.getDefinition();
                this.updateMessageHeaders(message, destination);
            }
        }
        if (!StringUtils.hasText((String)destination) && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Failed to discover function definition. Neither `spring.cloud.function.definition`, nor `.route(<function.definition>)`, nor `spring.cloud.function.routing-expression` were provided. Will use empty string for lookup, which will work only if there is one function in Function Catalog");
        }
        return destination;
    }

    private void updateMessageHeaders(Message<?> message, String destination) {
        Map headersMap = (Map)ReflectionUtils.getField((Field)this.headersField, (Object)message.getHeaders());
        PathPatternRouteMatcher matcher = new PathPatternRouteMatcher();
        headersMap.put(RECONCILED_LOOKUP_DESTINATION_HEADER, matcher.parseRoute(destination));
    }

    private static class HeadersAwareMetadataExtractor
    extends DefaultMetadataExtractor {
        HeadersAwareMetadataExtractor(List<Decoder<?>> decoders) {
            super(decoders);
            super.metadataToExtract(MimeTypeUtils.APPLICATION_JSON, (ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, String>>(){}, (jsonMap, outputMap) -> outputMap.putAll(jsonMap));
        }
    }

    protected static final class FunctionRSocketPayloadReturnValueHandler
    extends RSocketPayloadReturnValueHandler {
        public FunctionRSocketPayloadReturnValueHandler(List<Encoder<?>> encoders, ReactiveAdapterRegistry registry) {
            super(encoders, registry);
        }

        public Mono<Void> handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, Message<?> message) {
            if (returnValue instanceof Publisher && !message.getHeaders().containsKey((Object)"rsocketResponse")) {
                return Mono.from((Publisher)((Publisher)returnValue)).then();
            }
            return super.handleReturnValue(returnValue, returnType, message);
        }
    }

    protected static final class MessageHandlerMethodArgumentResolver
    implements SyncHandlerMethodArgumentResolver {
        private final Decoder<byte[]> decoder = new ByteArrayDecoder();
        private final JsonMapper jsonMapper;
        private final List<? extends HandlerMethodArgumentResolver> resolvers;

        MessageHandlerMethodArgumentResolver(JsonMapper jsonMapper, List<? extends HandlerMethodArgumentResolver> resolvers) {
            this.jsonMapper = jsonMapper;
            this.resolvers = resolvers;
        }

        public boolean supportsParameter(MethodParameter parameter) {
            return true;
        }

        public Object resolveArgumentValue(MethodParameter parameter, Message<?> message) {
            Flux data;
            Object payload = message.getPayload();
            Flux flux = data = payload instanceof DataBuffer ? Flux.just((Object)((DataBuffer)payload)) : Flux.from((Publisher)((Publisher)payload));
            if (message.getHeaders().containsKey((Object)"contentType") && "application/json".equals(message.getHeaders().get((Object)"contentType").toString())) {
                Flux argument = data.map(buffer -> {
                    Object structure;
                    byte[] bytePayload = (byte[])this.decoder.decode(buffer, ResolvableType.forType(byte[].class), null, null);
                    if (JsonMapper.isJsonString((Object)bytePayload) && (structure = this.jsonMapper.fromJson((Object)bytePayload, Object.class)) instanceof Map && ((Map)structure).containsKey(FunctionRSocketUtils.PAYLOAD)) {
                        return MessageBuilder.withPayload(((Map)structure).remove(FunctionRSocketUtils.PAYLOAD)).copyHeaders((Map)((Map)structure).get(FunctionRSocketUtils.HEADERS)).build();
                    }
                    return MessageBuilder.withPayload((Object)bytePayload).copyHeadersIfAbsent((Map)message.getHeaders()).build();
                });
                return MessageBuilder.createMessage((Object)argument, (MessageHeaders)message.getHeaders());
            }
            for (HandlerMethodArgumentResolver handlerMethodArgumentResolver : this.resolvers) {
                if (!handlerMethodArgumentResolver.supportsParameter(parameter)) continue;
                Mono arg = handlerMethodArgumentResolver.resolveArgument(parameter, message);
                return MessageBuilder.withPayload((Object)arg).copyHeadersIfAbsent((Map)message.getHeaders()).build();
            }
            return message;
        }
    }
}

