/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.grpc;

import com.google.protobuf.GeneratedMessageV3;
import org.springframework.cloud.function.grpc.GrpcMessageConverter;
import org.springframework.messaging.Message;

public abstract class AbstractGrpcMessageConverter<T extends GeneratedMessageV3>
implements GrpcMessageConverter<T> {
    @Override
    public Message<byte[]> toSpringMessage(T grpcMessage) {
        if (this.supports(grpcMessage)) {
            return this.doToSpringMessage(grpcMessage);
        }
        return null;
    }

    @Override
    public T fromSpringMessage(Message<byte[]> springMessage, Class<T> grpcClass) {
        if (this.supports(grpcClass)) {
            return this.doFromSpringMessage(springMessage);
        }
        return null;
    }

    protected abstract Message<byte[]> doToSpringMessage(T var1);

    protected abstract T doFromSpringMessage(Message<byte[]> var1);

    protected boolean supports(T grpcMessage) {
        return this.supports(grpcMessage.getClass());
    }

    protected abstract boolean supports(Class<? extends GeneratedMessageV3> var1);
}

