/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.deployer.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.function.deployer.utils.LoggingRepositoryListener;
import org.springframework.cloud.function.deployer.utils.MavenProperties;
import org.springframework.cloud.function.deployer.utils.MavenResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

class MavenArtifactResolver {
    private static final Logger logger = LoggerFactory.getLogger(MavenArtifactResolver.class);
    private static final String DEFAULT_CONTENT_TYPE = "default";
    private final RepositorySystem repositorySystem;
    private final MavenProperties properties;
    private final List<RemoteRepository> remoteRepositories = new LinkedList<RemoteRepository>();
    private final Authentication proxyAuthentication;

    MavenArtifactResolver(MavenProperties properties) {
        Assert.notNull((Object)properties, (String)"MavenProperties must not be null");
        Assert.notNull((Object)properties.getLocalRepository(), (String)"Local repository path cannot be null");
        this.properties = properties;
        if (logger.isDebugEnabled()) {
            logger.debug("Configured local repository: " + properties.getLocalRepository());
            logger.debug("Configured remote repositories: " + this.configuredRemoteRepositoriesDescription());
        }
        if (this.isProxyEnabled() && this.proxyHasCredentials()) {
            String username = this.properties.getProxy().getAuth().getUsername();
            String password = this.properties.getProxy().getAuth().getPassword();
            this.proxyAuthentication = this.newAuthentication(username, password);
        } else {
            this.proxyAuthentication = null;
        }
        File localRepository = new File(this.properties.getLocalRepository());
        if (!localRepository.exists()) {
            boolean created = localRepository.mkdirs();
            Assert.isTrue((created || localRepository.exists() ? 1 : 0) != 0, (String)("Unable to create directory for local repository: " + localRepository));
        }
        Map<String, String> defaultRepoUrlsToIds = this.defaultRemoteRepos();
        for (Map.Entry<String, MavenProperties.RemoteRepository> entry : this.properties.getRemoteRepositories().entrySet()) {
            MavenProperties.RemoteRepository remoteRepository = entry.getValue();
            RemoteRepository.Builder remoteRepositoryBuilder = new RemoteRepository.Builder(entry.getKey(), DEFAULT_CONTENT_TYPE, remoteRepository.getUrl());
            if (remoteRepository.getPolicy() != null) {
                remoteRepositoryBuilder.setPolicy(new RepositoryPolicy(remoteRepository.getPolicy().isEnabled(), remoteRepository.getPolicy().getUpdatePolicy(), remoteRepository.getPolicy().getChecksumPolicy()));
            }
            if (remoteRepository.getReleasePolicy() != null) {
                remoteRepositoryBuilder.setReleasePolicy(new RepositoryPolicy(remoteRepository.getReleasePolicy().isEnabled(), remoteRepository.getReleasePolicy().getUpdatePolicy(), remoteRepository.getReleasePolicy().getChecksumPolicy()));
            }
            if (remoteRepository.getSnapshotPolicy() != null) {
                remoteRepositoryBuilder.setSnapshotPolicy(new RepositoryPolicy(remoteRepository.getSnapshotPolicy().isEnabled(), remoteRepository.getSnapshotPolicy().getUpdatePolicy(), remoteRepository.getSnapshotPolicy().getChecksumPolicy()));
            }
            if (this.remoteRepositoryHasCredentials(remoteRepository)) {
                String username = remoteRepository.getAuth().getUsername();
                String password = remoteRepository.getAuth().getPassword();
                remoteRepositoryBuilder.setAuthentication(this.newAuthentication(username, password));
            }
            defaultRepoUrlsToIds.remove(remoteRepository.getUrl());
            RemoteRepository repo = this.proxyRepoIfProxyEnabled(remoteRepositoryBuilder.build());
            this.remoteRepositories.add(repo);
        }
        if (!defaultRepoUrlsToIds.isEmpty() && this.properties.isIncludeDefaultRemoteRepos()) {
            ArrayList defaultRepos = new ArrayList();
            defaultRepoUrlsToIds.forEach((url, id) -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding {} ({}) to remote repositories list", id, url);
                }
                RemoteRepository defaultRepo = this.proxyRepoIfProxyEnabled(new RemoteRepository.Builder(id, DEFAULT_CONTENT_TYPE, url).build());
                defaultRepos.add(defaultRepo);
            });
            this.remoteRepositories.addAll(0, defaultRepos);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Using remote repositories: {}", (Object)this.actualRemoteRepositoriesDescription());
        }
        this.repositorySystem = this.newRepositorySystem();
    }

    protected Map<String, String> defaultRemoteRepos() {
        LinkedHashMap<String, String> defaultRepos = new LinkedHashMap<String, String>();
        defaultRepos.put("https://repo.maven.apache.org/maven2", "mavenCentral-default");
        defaultRepos.put("https://repo.spring.io/snapshot", "springSnapshot-default");
        defaultRepos.put("https://repo.spring.io/milestone", "springMilestone-default");
        return defaultRepos;
    }

    private RemoteRepository proxyRepoIfProxyEnabled(RemoteRepository remoteRepo) {
        if (!this.isProxyEnabled()) {
            return remoteRepo;
        }
        MavenProperties.Proxy proxyProperties = this.properties.getProxy();
        Proxy proxy = this.proxyAuthentication != null ? new Proxy(proxyProperties.getProtocol(), proxyProperties.getHost(), proxyProperties.getPort(), this.proxyAuthentication) : new Proxy(proxyProperties.getProtocol(), proxyProperties.getHost(), proxyProperties.getPort());
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        proxySelector.add(proxy, this.properties.getProxy().getNonProxyHosts());
        proxy = proxySelector.getProxy(remoteRepo);
        RemoteRepository.Builder remoteRepositoryBuilder = new RemoteRepository.Builder(remoteRepo);
        remoteRepositoryBuilder.setProxy(proxy);
        return remoteRepositoryBuilder.build();
    }

    private boolean isProxyEnabled() {
        return this.properties.getProxy() != null && this.properties.getProxy().getHost() != null && this.properties.getProxy().getPort() > 0;
    }

    private boolean proxyHasCredentials() {
        return this.properties.getProxy() != null && this.properties.getProxy().getAuth() != null && this.properties.getProxy().getAuth().getUsername() != null && this.properties.getProxy().getAuth().getPassword() != null;
    }

    private boolean remoteRepositoryHasCredentials(MavenProperties.RemoteRepository remoteRepository) {
        return remoteRepository != null && remoteRepository.getAuth() != null && remoteRepository.getAuth().getUsername() != null && remoteRepository.getAuth().getPassword() != null;
    }

    private Authentication newAuthentication(final String username, final String password) {
        return new Authentication(){

            public void fill(AuthenticationContext context, String key, Map<String, String> data) {
                context.put("username", (Object)username);
                context.put("password", (Object)password);
            }

            public void digest(AuthenticationDigest digest) {
                digest.update(new String[]{"username", username, "password", password});
            }
        };
    }

    DefaultRepositorySystemSession newRepositorySystemSession() {
        return this.newRepositorySystemSession(this.repositorySystem, this.properties.getLocalRepository());
    }

    private DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoPath) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepoPath);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setOffline(this.properties.isOffline());
        session.setUpdatePolicy(this.properties.getUpdatePolicy());
        session.setChecksumPolicy(this.properties.getChecksumPolicy());
        if (this.properties.isEnableRepositoryListener()) {
            session.setRepositoryListener((RepositoryListener)new LoggingRepositoryListener());
        }
        if (this.properties.getConnectTimeout() != null) {
            session.setConfigProperty("aether.connector.connectTimeout", (Object)this.properties.getConnectTimeout());
        }
        if (this.properties.getRequestTimeout() != null) {
            session.setConfigProperty("aether.connector.requestTimeout", (Object)this.properties.getRequestTimeout());
        }
        if (this.isProxyEnabled()) {
            DefaultProxySelector proxySelector = new DefaultProxySelector();
            Proxy proxy = new Proxy(this.properties.getProxy().getProtocol(), this.properties.getProxy().getHost(), this.properties.getProxy().getPort(), this.proxyAuthentication);
            proxySelector.add(proxy, this.properties.getProxy().getNonProxyHosts());
            session.setProxySelector((ProxySelector)proxySelector);
        }
        for (Map.Entry<String, MavenProperties.RemoteRepository> entry : this.properties.getRemoteRepositories().entrySet()) {
            session.setConfigProperty("aether.connector.wagon.config." + entry.getKey(), (Object)entry.getValue().getWagon());
        }
        return session;
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                throw new RuntimeException(exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    List<RemoteRepository> remoteRepositories() {
        return Collections.unmodifiableList(this.remoteRepositories);
    }

    private String actualRemoteRepositoriesDescription() {
        return this.remoteRepositories.stream().map(repo -> String.format("%s (%s)", repo.getId(), repo.getUrl())).collect(Collectors.joining(", ", "[", "]"));
    }

    private String configuredRemoteRepositoriesDescription() {
        return this.properties.getRemoteRepositories().entrySet().stream().map(e -> String.format("%s (%s)", e.getKey(), ((MavenProperties.RemoteRepository)e.getValue()).getUrl())).collect(Collectors.joining(", ", "[", "]"));
    }

    List<String> getVersions(String coordinates) {
        DefaultArtifact artifact = new DefaultArtifact(coordinates);
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact((Artifact)artifact);
        rangeRequest.setRepositories(this.remoteRepositories);
        try {
            VersionRangeResult versionResult = this.repositorySystem.resolveVersionRange((RepositorySystemSession)this.newRepositorySystemSession(), rangeRequest);
            ArrayList<String> versions = new ArrayList<String>();
            for (Version version : versionResult.getVersions()) {
                versions.add(version.toString());
            }
            return versions;
        }
        catch (VersionRangeResolutionException e) {
            throw new IllegalStateException(e);
        }
    }

    Resource resolve(MavenResource resource) {
        Assert.notNull((Object)((Object)resource), (String)"MavenResource must not be null");
        this.validateCoordinates(resource);
        DefaultRepositorySystemSession session = this.newRepositorySystemSession(this.repositorySystem, this.properties.getLocalRepository());
        try {
            ArrayList<ArtifactRequest> artifactRequests = new ArrayList<ArtifactRequest>(2);
            if (this.properties.isResolvePom()) {
                artifactRequests.add(new ArtifactRequest(this.toPomArtifact(resource), this.remoteRepositories, "runtime"));
            }
            artifactRequests.add(new ArtifactRequest(this.toJarArtifact(resource), this.remoteRepositories, "runtime"));
            List results = this.repositorySystem.resolveArtifacts((RepositorySystemSession)session, artifactRequests);
            return this.toResource((ArtifactResult)results.get(results.size() - 1));
        }
        catch (ArtifactResolutionException ex) {
            String errorMsg = String.format("Failed to resolve %s using remote repo(s): %s", new Object[]{resource, this.actualRemoteRepositoriesDescription()});
            throw new IllegalStateException(errorMsg, ex);
        }
    }

    private void validateCoordinates(MavenResource resource) {
        Assert.hasText((String)resource.getGroupId(), (String)"groupId must not be blank.");
        Assert.hasText((String)resource.getArtifactId(), (String)"artifactId must not be blank.");
        Assert.hasText((String)resource.getExtension(), (String)"extension must not be blank.");
        Assert.hasText((String)resource.getVersion(), (String)"version must not be blank.");
    }

    public FileSystemResource toResource(ArtifactResult resolvedArtifact) {
        return new FileSystemResource(resolvedArtifact.getArtifact().getFile());
    }

    private Artifact toJarArtifact(MavenResource resource) {
        return this.toArtifact(resource, resource.getExtension());
    }

    private Artifact toPomArtifact(MavenResource resource) {
        return this.toArtifact(resource, "pom");
    }

    private Artifact toArtifact(MavenResource resource, String extension) {
        return new DefaultArtifact(resource.getGroupId(), resource.getArtifactId(), resource.getClassifier() != null ? resource.getClassifier() : "", extension, resource.getVersion());
    }
}

