/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.compiler.java;

public class CompilationMessage {
    private Kind kind;
    private String message;
    private String sourceCode;
    private int startPosition;
    private int endPosition;

    public CompilationMessage(Kind kind, String message, String sourceCode, int startPosition, int endPosition) {
        this.kind = kind;
        this.message = message;
        this.sourceCode = sourceCode;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("==========\n");
        if (this.sourceCode != null) {
            int[] lineStartEnd = this.getLineStartEnd(this.startPosition);
            s.append(this.sourceCode.substring(lineStartEnd[0], lineStartEnd[1])).append("\n");
            int col = lineStartEnd[0];
            while (col < this.startPosition) {
                s.append(this.sourceCode.charAt(col++) == '\t' ? "\t" : " ");
            }
            s.append("^");
            while (true) {
                int n = ++col;
                ++col;
                if (n >= this.endPosition) break;
                s.append("^");
            }
            s.append("\n");
        }
        s.append((Object)this.kind).append(":").append(this.message).append("\n");
        s.append("==========\n");
        return s.toString();
    }

    private int[] getLineStartEnd(int searchPos) {
        int previousPos = -1;
        int pos = 0;
        do {
            if (searchPos < (pos = this.sourceCode.indexOf(10, previousPos + 1))) {
                return new int[]{previousPos + 1, pos};
            }
            previousPos = pos;
        } while (pos != -1);
        return new int[]{previousPos + 1, this.sourceCode.length()};
    }

    static enum Kind {
        ERROR,
        OTHER;

    }
}

