/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import reactor.core.publisher.Flux;

public final class AzureFunctionUtil {
    public static String EXECUTION_CONTEXT = "executionContext";

    private AzureFunctionUtil() {
    }

    public static <I> Object enhanceInputIfNecessary(Object input, ExecutionContext executionContext) {
        if (input == null) {
            return input;
        }
        if (input instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)input)).map(item -> {
                if (item instanceof Message) {
                    return MessageBuilder.fromMessage((Message)((Message)item)).setHeaderIfAbsent(EXECUTION_CONTEXT, (Object)executionContext).build();
                }
                return AzureFunctionUtil.constructInputMessageFromItem(input, executionContext);
            });
        }
        if (input instanceof Message) {
            return MessageBuilder.fromMessage((Message)((Message)input)).setHeaderIfAbsent(EXECUTION_CONTEXT, (Object)executionContext).build();
        }
        if (input instanceof Iterable) {
            return Flux.fromIterable((Iterable)((Iterable)input)).map(item -> AzureFunctionUtil.constructInputMessageFromItem(item, executionContext));
        }
        return AzureFunctionUtil.constructInputMessageFromItem(input, executionContext);
    }

    private static <I> Message<?> constructInputMessageFromItem(Object input, ExecutionContext executionContext) {
        MessageBuilder messageBuilder = null;
        if (input instanceof HttpRequestMessage) {
            Optional payload;
            HttpRequestMessage requestMessage = (HttpRequestMessage)input;
            Optional optional = payload = requestMessage.getHttpMethod() != null && requestMessage.getHttpMethod().equals((Object)HttpMethod.GET) ? requestMessage.getQueryParameters() : requestMessage.getBody();
            if (payload == null) {
                payload = Optional.empty();
            }
            messageBuilder = MessageBuilder.withPayload(payload).copyHeaders((Map)AzureFunctionUtil.getHeaders(requestMessage));
        } else {
            messageBuilder = MessageBuilder.withPayload((Object)input);
        }
        return messageBuilder.setHeaderIfAbsent(EXECUTION_CONTEXT, (Object)executionContext).build();
    }

    private static <I> MessageHeaders getHeaders(HttpRequestMessage<I> event) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (event.getHeaders() != null) {
            headers.putAll(event.getHeaders());
        }
        if (event.getQueryParameters() != null) {
            headers.putAll(event.getQueryParameters());
        }
        if (event.getUri() != null) {
            headers.put("path", event.getUri().getPath());
        }
        if (event.getHttpMethod() != null) {
            headers.put("httpMethod", event.getHttpMethod().toString());
        }
        headers.put("request", event.getBody());
        return new MessageHeaders(headers);
    }
}

