/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.azure;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.functions.ExecutionContext;
import com.microsoft.azure.functions.HttpMethod;
import com.microsoft.azure.functions.HttpRequestMessage;
import com.microsoft.azure.functions.HttpResponseMessage;
import com.microsoft.azure.functions.HttpStatus;
import com.microsoft.azure.functions.OutputBinding;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.FunctionRegistry;
import org.springframework.cloud.function.context.FunctionalSpringApplication;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.context.config.FunctionContextUtils;
import org.springframework.cloud.function.context.config.JsonMessageConverter;
import org.springframework.cloud.function.context.config.SmartCompositeMessageConverter;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
public class FunctionInvoker<I, O> {
    private static Log logger = LogFactory.getLog(FunctionInvoker.class);
    private static String EXECUTION_CONTEXT = "executionContext";
    private static FunctionCatalog FUNCTION_CATALOG;
    private static ConfigurableApplicationContext APPLICATION_CONTEXT;
    private static JsonMapper OBJECT_MAPPER;
    private static final ReentrantLock globalLock;

    public FunctionInvoker(Class<?> configurationClass) {
        try {
            FunctionInvoker.initialize(configurationClass);
        }
        catch (Exception e) {
            this.close();
            throw new IllegalStateException("Failed to initialize", e);
        }
    }

    public FunctionInvoker() {
        this(FunctionClassUtils.getStartClass());
    }

    public O handleRequest(ExecutionContext context) {
        return this.handleRequest(null, context);
    }

    public void close() {
        FUNCTION_CATALOG = null;
    }

    public void handleOutput(I input, OutputBinding<O> binding, ExecutionContext context) {
        O result = this.handleRequest(input, context);
        binding.setValue(result);
    }

    private SimpleFunctionRegistry.FunctionInvocationWrapper discoverFunction(String functionDefinition) {
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)FUNCTION_CATALOG.lookup(functionDefinition);
        if (function != null && StringUtils.hasText((String)functionDefinition) && !function.getFunctionDefinition().equals(functionDefinition)) {
            this.registerFunction(functionDefinition);
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)FUNCTION_CATALOG.lookup(functionDefinition);
        } else if (function == null && StringUtils.hasText((String)functionDefinition) && APPLICATION_CONTEXT.containsBean(functionDefinition)) {
            this.registerFunction(functionDefinition);
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)FUNCTION_CATALOG.lookup(functionDefinition);
        }
        return function;
    }

    public O handleRequest(I input, ExecutionContext executionContext) {
        Object enhancedInput;
        String functionDefinition = executionContext.getFunctionName();
        SimpleFunctionRegistry.FunctionInvocationWrapper function = this.discoverFunction(functionDefinition);
        Object functionResult = function.apply(enhancedInput = this.enhanceInputIfNecessary(input, executionContext));
        if (functionResult instanceof Publisher) {
            return this.postProcessReactiveFunctionResult(input, enhancedInput, (Publisher)functionResult, function, executionContext);
        }
        return this.postProcessImperativeFunctionResult(input, enhancedInput, functionResult, function, executionContext);
    }

    protected O postProcessImperativeFunctionResult(I rawInputs, Object functionInputs, Object functionResult, SimpleFunctionRegistry.FunctionInvocationWrapper function, ExecutionContext executionContext) {
        return (O)this.convertOutputIfNecessary(rawInputs, functionResult);
    }

    protected O postProcessReactiveFunctionResult(I rawInputs, Object functionInputs, Publisher<?> functionResult, SimpleFunctionRegistry.FunctionInvocationWrapper function, ExecutionContext executionContext) {
        if (FunctionTypeUtils.isMono((Type)function.getOutputType())) {
            return this.postProcessMonoFunctionResult(rawInputs, functionInputs, Mono.from(functionResult), function, executionContext);
        }
        return this.postProcessFluxFunctionResult(rawInputs, functionInputs, Flux.from(functionResult), function, executionContext);
    }

    protected O postProcessMonoFunctionResult(I rawInputs, Object functionInputs, Mono<?> functionResult, SimpleFunctionRegistry.FunctionInvocationWrapper function, ExecutionContext executionContext) {
        return (O)this.convertOutputIfNecessary(rawInputs, functionResult.blockOptional().get());
    }

    protected O postProcessFluxFunctionResult(I rawInputs, Object functionInputs, Flux<?> functionResult, SimpleFunctionRegistry.FunctionInvocationWrapper function, ExecutionContext executionContext) {
        ArrayList resultList = new ArrayList();
        for (Object resultItem : functionResult.toIterable()) {
            if (resultItem instanceof Collection) {
                resultList.addAll((Collection)resultItem);
                continue;
            }
            if (!function.isSupplier() && Collection.class.isAssignableFrom(FunctionTypeUtils.getRawType((Type)function.getInputType())) && !Collection.class.isAssignableFrom(FunctionTypeUtils.getRawType((Type)function.getOutputType()))) {
                return (O)this.convertOutputIfNecessary(rawInputs, resultItem);
            }
            resultList.add(resultItem);
        }
        return (O)this.convertOutputIfNecessary(rawInputs, resultList);
    }

    private void registerFunction(String functionDefinition) {
        if (APPLICATION_CONTEXT.containsBean(functionDefinition)) {
            FunctionRegistration functionRegistration = new FunctionRegistration(APPLICATION_CONTEXT.getBean(functionDefinition), new String[]{functionDefinition});
            Type type = FunctionContextUtils.findType((String)functionDefinition, (ConfigurableListableBeanFactory)APPLICATION_CONTEXT.getBeanFactory());
            functionRegistration = functionRegistration.type(type);
            ((FunctionRegistry)FUNCTION_CATALOG).register(functionRegistration);
        }
    }

    private Object enhanceInputIfNecessary(Object input, ExecutionContext executionContext) {
        if (input == null) {
            return input;
        }
        if (input instanceof Publisher) {
            return Flux.from((Publisher)((Publisher)input)).map(item -> {
                if (item instanceof Message) {
                    return MessageBuilder.fromMessage((Message)((Message)item)).setHeaderIfAbsent(EXECUTION_CONTEXT, (Object)executionContext).build();
                }
                return this.constructInputMessageFromItem(input, executionContext);
            });
        }
        if (input instanceof Message) {
            return MessageBuilder.fromMessage((Message)((Message)input)).setHeaderIfAbsent(EXECUTION_CONTEXT, (Object)executionContext).build();
        }
        if (input instanceof Iterable) {
            return Flux.fromIterable((Iterable)((Iterable)input)).map(item -> this.constructInputMessageFromItem(item, executionContext));
        }
        return this.constructInputMessageFromItem(input, executionContext);
    }

    private Object convertOutputIfNecessary(Object input, Object output) {
        if (input instanceof HttpRequestMessage) {
            HttpRequestMessage requestMessage = (HttpRequestMessage)input;
            MessageHeaders headers = null;
            if (output instanceof Message) {
                headers = ((Message)output).getHeaders();
                output = ((Message)output).getPayload();
            }
            HttpResponseMessage.Builder responseBuilder = requestMessage.createResponseBuilder(HttpStatus.OK).body(output);
            if (headers != null) {
                for (Map.Entry headersEntry : headers.entrySet()) {
                    if (headersEntry.getValue() == null) continue;
                    responseBuilder.header((String)headersEntry.getKey(), headersEntry.getValue().toString());
                }
            }
            return responseBuilder.build();
        }
        return output;
    }

    private Message<?> constructInputMessageFromItem(Object input, ExecutionContext executionContext) {
        MessageBuilder messageBuilder = null;
        if (input instanceof HttpRequestMessage) {
            Optional payload;
            HttpRequestMessage requestMessage = (HttpRequestMessage)input;
            Optional optional = payload = requestMessage.getHttpMethod() != null && requestMessage.getHttpMethod().equals((Object)HttpMethod.GET) ? requestMessage.getQueryParameters() : requestMessage.getBody();
            if (payload == null) {
                payload = Optional.empty();
            }
            messageBuilder = MessageBuilder.withPayload(payload).copyHeaders((Map)this.getHeaders(requestMessage));
        } else {
            messageBuilder = MessageBuilder.withPayload((Object)input);
        }
        return messageBuilder.setHeaderIfAbsent(EXECUTION_CONTEXT, (Object)executionContext).build();
    }

    private MessageHeaders getHeaders(HttpRequestMessage<I> event) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (event.getHeaders() != null) {
            headers.putAll(event.getHeaders());
        }
        if (event.getQueryParameters() != null) {
            headers.putAll(event.getQueryParameters());
        }
        if (event.getUri() != null) {
            headers.put("path", event.getUri().getPath());
        }
        if (event.getHttpMethod() != null) {
            headers.put("httpMethod", event.getHttpMethod().toString());
        }
        headers.put("request", event.getBody());
        return new MessageHeaders(headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(Class<?> configurationClass) {
        if (FUNCTION_CATALOG == null) {
            try {
                globalLock.lock();
                if (FUNCTION_CATALOG == null) {
                    logger.info((Object)("Initializing: " + configurationClass));
                    SpringApplication builder = FunctionInvoker.springApplication(configurationClass);
                    APPLICATION_CONTEXT = builder.run(new String[0]);
                    Map mf = APPLICATION_CONTEXT.getBeansOfType(FunctionCatalog.class);
                    if (CollectionUtils.isEmpty((Map)mf)) {
                        OBJECT_MAPPER = new JacksonMapper(new ObjectMapper());
                        JsonMessageConverter jsonConverter = new JsonMessageConverter(OBJECT_MAPPER);
                        SmartCompositeMessageConverter messageConverter = new SmartCompositeMessageConverter(Collections.singletonList(jsonConverter));
                        FUNCTION_CATALOG = new SimpleFunctionRegistry(APPLICATION_CONTEXT.getBeanFactory().getConversionService(), (CompositeMessageConverter)messageConverter, OBJECT_MAPPER);
                    } else {
                        OBJECT_MAPPER = (JsonMapper)APPLICATION_CONTEXT.getBean(JsonMapper.class);
                        FUNCTION_CATALOG = (FunctionCatalog)mf.values().iterator().next();
                    }
                }
            }
            finally {
                globalLock.unlock();
            }
        }
    }

    private static SpringApplication springApplication(Class<?> configurationClass) {
        FunctionalSpringApplication application = new FunctionalSpringApplication(new Class[]{configurationClass});
        application.setWebApplicationType(WebApplicationType.NONE);
        return application;
    }

    static {
        globalLock = new ReentrantLock();
    }
}

