/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.CommandLineRunner;
import org.springframework.cloud.function.adapter.aws.CustomRuntimeAutoConfiguration;
import org.springframework.cloud.function.adapter.aws.CustomRuntimeEventLoop;
import org.springframework.cloud.function.adapter.aws.LambdaDestinationResolver;
import org.springframework.cloud.function.context.config.ContextFunctionCatalogInitializer;
import org.springframework.cloud.function.web.source.DestinationResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=0)
public class CustomRuntimeInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private static Log logger = LogFactory.getLog(CustomRuntimeInitializer.class);

    public void initialize(GenericApplicationContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("AWS Environment: " + System.getenv()));
        }
        if (!this.isWebExportEnabled(context) && StringUtils.hasText((String)System.getenv("AWS_LAMBDA_RUNTIME_API"))) {
            if (context.getBeanFactory().getBeanNamesForType(CustomRuntimeEventLoop.class, false, false).length == 0) {
                context.registerBean(StringUtils.uncapitalize((String)CustomRuntimeEventLoop.class.getSimpleName()), CommandLineRunner.class, () -> args -> CustomRuntimeEventLoop.eventLoop((ApplicationContext)context), new BeanDefinitionCustomizer[0]);
            }
        } else if (ContextFunctionCatalogInitializer.enabled && ((Boolean)context.getEnvironment().getProperty("spring.functional.enabled", Boolean.class, (Object)false)).booleanValue()) {
            if (context.getBeanFactory().getBeanNamesForType(DestinationResolver.class, false, false).length == 0) {
                context.registerBean(LambdaDestinationResolver.class, () -> new LambdaDestinationResolver(), new BeanDefinitionCustomizer[0]);
            }
            context.registerBean(StringUtils.uncapitalize((String)CustomRuntimeAutoConfiguration.class.getSimpleName()), CommandLineRunner.class, () -> args -> CustomRuntimeAutoConfiguration.background(), new BeanDefinitionCustomizer[0]);
        }
    }

    private boolean isWebExportEnabled(GenericApplicationContext context) {
        Boolean enabled = (Boolean)context.getEnvironment().getProperty("spring.cloud.function.web.export.enabled", Boolean.class);
        return enabled != null && enabled != false;
    }
}

