/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.adapter.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.utils.FunctionClassUtils;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class FunctionInvoker
implements RequestStreamHandler {
    private static Log logger = LogFactory.getLog(FunctionInvoker.class);
    private ObjectMapper mapper;
    private Function<Message<byte[]>, Message<byte[]>> function;

    public FunctionInvoker() {
        this.start();
    }

    public void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        Message<byte[]> requestMessage = this.generateMessage(input, context);
        Message<byte[]> responseMessage = this.function.apply(requestMessage);
        byte[] responseBytes = (byte[])responseMessage.getPayload();
        if (requestMessage.getHeaders().containsKey((Object)"httpMethod")) {
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("isBase64Encoded", false);
            response.put("statusCode", 200);
            response.put("body", new String((byte[])responseMessage.getPayload(), StandardCharsets.UTF_8));
            response.put("headers", Collections.singletonMap("foo", "bar"));
            responseBytes = this.mapper.writeValueAsBytes(response);
        }
        StreamUtils.copy((byte[])responseBytes, (OutputStream)output);
    }

    private void start() {
        ConfigurableApplicationContext context = SpringApplication.run((Class)FunctionClassUtils.getStartClass(), (String[])new String[0]);
        ConfigurableEnvironment environment = context.getEnvironment();
        String functionName = environment.getProperty("spring.cloud.function.definition");
        FunctionCatalog functionCatalog = (FunctionCatalog)context.getBean(FunctionCatalog.class);
        this.mapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        this.configureObjectMapper();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Locating function: '" + functionName + "'"));
        }
        this.function = (Function)functionCatalog.lookup(functionName, new String[]{"application/json"});
        Assert.notNull(this.function, (String)("Failed to lookup function " + functionName));
        if (!StringUtils.hasText((String)functionName)) {
            FunctionInspector inspector = (FunctionInspector)context.getBean(FunctionInspector.class);
            functionName = inspector.getRegistration(this.function).getNames().toString();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Located function: '" + functionName + "'"));
        }
    }

    private void configureObjectMapper() {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Date.class, (JsonDeserializer)new JsonDeserializer<Date>(){

            public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(jsonParser.getValueAsLong());
                return calendar.getTime();
            }
        });
        this.mapper.registerModule((Module)module);
        this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    private Message<byte[]> generateMessage(InputStream input, Context context) throws IOException {
        byte[] payload = StreamUtils.copyToByteArray((InputStream)input);
        Message message = MessageBuilder.withPayload((Object)payload).setHeader("aws-context", (Object)context).build();
        return message;
    }
}

