/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.deployer.spi.yarn.AbstractDeployerStateMachine;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.TaskExecutor;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.guard.Guard;
import org.springframework.util.StringUtils;

public class AppDeployerStateMachine
extends AbstractDeployerStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(AppDeployerStateMachine.class);
    private static final String MODEL_LOCATION = "classpath:appdeployer-model.uml";
    public static final String EVENT_DEPLOY = "DEPLOY";
    public static final String EVENT_UNDEPLOY = "UNDEPLOY";
    public static final String VAR_INSTANCE_ADDRESS = "instanceAddress";
    public static final String VAR_COUNT = "count";
    public static final String VAR_APPNAME = "appname";
    public static final String VAR_CLUSTER_ID = "clusterId";
    public static final String VAR_DEFINITION_PARAMETERS = "definitionParameters";
    public static final String HEADER_CLUSTER_ID = "clusterId";
    public static final String HEADER_COUNT = "count";
    public static final String HEADER_DEFINITION_PARAMETERS = "definitionParameters";

    public AppDeployerStateMachine(YarnCloudAppService yarnCloudAppService, TaskExecutor taskExecutor, BeanFactory beanFactory, ResourceLoader resourceLoader) {
        super(yarnCloudAppService, taskExecutor, beanFactory, resourceLoader, MODEL_LOCATION);
    }

    @Override
    protected Map<String, Action<String, String>> getRegisteredActions() {
        HashMap<String, Action<String, String>> actions = new HashMap<String, Action<String, String>>();
        actions.put("resetVariablesAction", new AbstractDeployerStateMachine.ResetVariablesAction(this));
        actions.put("deployAction", new DeployAction());
        actions.put("checkAppAction", new AbstractDeployerStateMachine.CheckAppAction(this, YarnCloudAppService.CloudAppType.STREAM));
        actions.put("pushAppAction", new AbstractDeployerStateMachine.PushAppAction(this, YarnCloudAppService.CloudAppType.STREAM));
        actions.put("checkInstanceAction", new CheckInstanceAction());
        actions.put("pushArtifactAction", new AbstractDeployerStateMachine.PushArtifactAction(this));
        actions.put("startInstanceAction", new StartInstanceAction());
        actions.put("waitInstanceAction", new WaitInstanceAction());
        actions.put("resolveInstanceAction", new ResolveInstanceAction());
        actions.put("createClusterAction", new CreateClusterAction());
        actions.put("startClusterAction", new StartClusterAction());
        actions.put("stopClusterAction", new StopClusterAction());
        actions.put("destroyClusterAction", new DestroyClusterAction());
        actions.put("errorHandlingAction", new AbstractDeployerStateMachine.ErrorAction(this));
        return actions;
    }

    @Override
    protected Map<String, Guard<String, String>> getRegisteredGuards() {
        HashMap<String, Guard<String, String>> guards = new HashMap<String, Guard<String, String>>();
        guards.put("pushAppGuard", new AbstractDeployerStateMachine.PushAppGuard(this));
        guards.put("startInstanceGuard", new StartInstanceGuard());
        guards.put("errorGuard", new AbstractDeployerStateMachine.ErrorGuard(this));
        guards.put("instanceGuard", new InstanceGuard());
        return guards;
    }

    private YarnCloudAppService.CloudAppInstanceInfo findRunningInstance(String appName) {
        for (YarnCloudAppService.CloudAppInstanceInfo appInstanceInfo : this.getYarnCloudAppService().getInstances(YarnCloudAppService.CloudAppType.STREAM)) {
            logger.info("Checking instance {} for appName {}", (Object)appInstanceInfo, (Object)appName);
            if (!appInstanceInfo.getName().equals(appName) || !appInstanceInfo.getState().equals("RUNNING") || !appInstanceInfo.getAddress().contains("http")) continue;
            logger.info("Using instance {}", (Object)appInstanceInfo);
            return appInstanceInfo;
        }
        return null;
    }

    private class InstanceGuard
    implements Guard<String, String> {
        private InstanceGuard() {
        }

        public boolean evaluate(StateContext<String, String> context) {
            return context.getExtendedState().getVariables().containsKey(AppDeployerStateMachine.VAR_INSTANCE_ADDRESS);
        }
    }

    private class DestroyClusterAction
    implements Action<String, String> {
        private DestroyClusterAction() {
        }

        public void execute(StateContext<String, String> context) {
            String clusterId = (String)context.getMessageHeaders().get((Object)"clusterId", String.class);
            String applicationId = (String)context.getMessageHeader((Object)"applicationId");
            AppDeployerStateMachine.this.getYarnCloudAppService().destroyCluster(applicationId, clusterId);
        }
    }

    private class StopClusterAction
    implements Action<String, String> {
        private StopClusterAction() {
        }

        public void execute(StateContext<String, String> context) {
            String clusterId = (String)context.getMessageHeaders().get((Object)"clusterId", String.class);
            String applicationId = (String)context.getMessageHeader((Object)"applicationId");
            AppDeployerStateMachine.this.getYarnCloudAppService().stopCluster(applicationId, clusterId);
        }
    }

    private class StartInstanceGuard
    implements Guard<String, String> {
        private StartInstanceGuard() {
        }

        public boolean evaluate(StateContext<String, String> context) {
            return !context.getExtendedState().getVariables().containsKey("applicationId");
        }
    }

    private class DeployAction
    implements Action<String, String> {
        private DeployAction() {
        }

        public void execute(StateContext<String, String> context) {
            Integer count = (Integer)context.getMessageHeaders().get((Object)"count", Integer.class);
            String clusterId = (String)context.getMessageHeaders().get((Object)"clusterId", String.class);
            Map definitionParameters = (Map)context.getMessageHeaders().get((Object)"definitionParameters", Map.class);
            Resource artifact = (Resource)context.getMessageHeaders().get((Object)"artifact", Resource.class);
            context.getExtendedState().getVariables().put("count", count != null ? count : 1);
            context.getExtendedState().getVariables().put("clusterId", clusterId);
            context.getExtendedState().getVariables().put("definitionParameters", definitionParameters);
            if (artifact != null) {
                context.getExtendedState().getVariables().put("artifact", artifact);
            }
            context.getExtendedState().getVariables().put("messageId", context.getMessageHeaders().getId().toString());
        }
    }

    private class StartClusterAction
    implements Action<String, String> {
        private StartClusterAction() {
        }

        public void execute(StateContext<String, String> context) {
            AppDeployerStateMachine.this.getYarnCloudAppService().startCluster((String)context.getExtendedState().get((Object)"applicationId", String.class), (String)context.getExtendedState().get((Object)"clusterId", String.class));
        }
    }

    private class CreateClusterAction
    implements Action<String, String> {
        private CreateClusterAction() {
        }

        public void execute(StateContext<String, String> context) {
            Resource artifact = (Resource)context.getExtendedState().get((Object)"artifact", Resource.class);
            AppDeployerStateMachine.this.getYarnCloudAppService().createCluster((String)context.getExtendedState().get((Object)"applicationId", String.class), (String)context.getExtendedState().get((Object)"clusterId", String.class), (Integer)context.getExtendedState().get((Object)"count", Integer.class), artifact != null ? artifact.getFilename() : null, (Map)context.getExtendedState().get((Object)"definitionParameters", Map.class));
        }
    }

    private class ResolveInstanceAction
    implements Action<String, String> {
        private ResolveInstanceAction() {
        }

        public void execute(StateContext<String, String> context) {
            String appName = (String)context.getExtendedState().get((Object)AppDeployerStateMachine.VAR_APPNAME, String.class);
            String applicationId = (String)context.getExtendedState().get((Object)"applicationId", String.class);
            YarnCloudAppService.CloudAppInstanceInfo appInstanceInfo = AppDeployerStateMachine.this.findRunningInstance(appName);
            if (appInstanceInfo != null && appInstanceInfo.getApplicationId().equals(applicationId)) {
                context.getExtendedState().getVariables().put(AppDeployerStateMachine.VAR_INSTANCE_ADDRESS, appInstanceInfo.getAddress());
            }
        }
    }

    private class WaitInstanceAction
    implements Action<String, String> {
        private WaitInstanceAction() {
        }

        public void execute(StateContext<String, String> context) {
            String appVersion = (String)context.getMessageHeader((Object)"appVersion");
            String groupId = (String)context.getMessageHeader((Object)"groupId");
            if (StringUtils.hasText((String)appVersion) && StringUtils.hasText((String)groupId)) {
                String appName = "scdstream:" + appVersion + ":" + groupId;
                context.getExtendedState().getVariables().put(AppDeployerStateMachine.VAR_APPNAME, appName);
            }
        }
    }

    private class StartInstanceAction
    implements Action<String, String> {
        private StartInstanceAction() {
        }

        public void execute(StateContext<String, String> context) {
            String appVersion = (String)context.getMessageHeader((Object)"appVersion");
            List contextRunArgs = (List)context.getMessageHeader((Object)"contextRunArgs");
            String applicationId = AppDeployerStateMachine.this.getYarnCloudAppService().submitApplication(appVersion, YarnCloudAppService.CloudAppType.STREAM, contextRunArgs);
            context.getExtendedState().getVariables().put("applicationId", applicationId);
        }
    }

    private class CheckInstanceAction
    implements Action<String, String> {
        private CheckInstanceAction() {
        }

        public void execute(StateContext<String, String> context) {
            String appVersion = (String)context.getMessageHeader((Object)"appVersion");
            String groupId = (String)context.getMessageHeader((Object)"groupId");
            String appName = "scdstream:" + appVersion + ":" + groupId;
            YarnCloudAppService.CloudAppInstanceInfo appInstanceInfo = AppDeployerStateMachine.this.findRunningInstance(appName);
            if (appInstanceInfo != null) {
                context.getExtendedState().getVariables().put("applicationId", appInstanceInfo.getApplicationId());
            }
        }
    }
}

