/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.yarn.autoconfigure;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.yarn.AppDeployerStateMachine;
import org.springframework.cloud.deployer.spi.yarn.DefaultYarnCloudAppService;
import org.springframework.cloud.deployer.spi.yarn.TaskLauncherStateMachine;
import org.springframework.cloud.deployer.spi.yarn.YarnAppDeployer;
import org.springframework.cloud.deployer.spi.yarn.YarnCloudAppService;
import org.springframework.cloud.deployer.spi.yarn.YarnDeployerProperties;
import org.springframework.cloud.deployer.spi.yarn.YarnTaskLauncher;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnClass(value={AppDeployer.class, TaskLauncher.class})
@EnableConfigurationProperties(value={YarnDeployerProperties.class})
public class YarnDeployerAutoConfiguration {
    @Value(value="${spring.cloud.dataflow.yarn.version:}")
    private String dataflowVersion;

    @Bean
    public YarnCloudAppService yarnCloudAppService() {
        return new DefaultYarnCloudAppService(this.dataflowVersion);
    }

    @Bean
    public TaskExecutor yarnModuleDeployerTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(1);
        return executor;
    }

    @Configuration
    @ConditionalOnMissingBean(name={"taskLauncher"})
    public static class TaskModuleDeployerConfig {
        @Bean
        public TaskLauncherStateMachine taskLauncherStateMachine(YarnCloudAppService yarnCloudAppService, TaskExecutor yarnModuleDeployerTaskExecutor, BeanFactory beanFactory, ApplicationContext applicationContext) throws Exception {
            return new TaskLauncherStateMachine(yarnCloudAppService, yarnModuleDeployerTaskExecutor, beanFactory, (ResourceLoader)applicationContext);
        }

        @Bean
        public TaskLauncher taskLauncher(YarnCloudAppService yarnCloudAppService, TaskLauncherStateMachine taskLauncherStateMachine) throws Exception {
            return new YarnTaskLauncher(yarnCloudAppService, taskLauncherStateMachine.buildStateMachine());
        }
    }

    @Configuration
    @ConditionalOnMissingBean(name={"appDeployer"})
    public static class ProcessModuleDeployerConfig {
        @Bean
        public AppDeployerStateMachine appDeployerStateMachine(YarnCloudAppService yarnCloudAppService, TaskExecutor yarnModuleDeployerTaskExecutor, BeanFactory beanFactory, ApplicationContext applicationContext) throws Exception {
            return new AppDeployerStateMachine(yarnCloudAppService, yarnModuleDeployerTaskExecutor, beanFactory, (ResourceLoader)applicationContext);
        }

        @Bean
        public AppDeployer appDeployer(YarnCloudAppService yarnCloudAppService, AppDeployerStateMachine appDeployerStateMachine) throws Exception {
            return new YarnAppDeployer(yarnCloudAppService, appDeployerStateMachine.buildStateMachine());
        }
    }
}

