/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.deployer.spi.util.RuntimeVersionUtils;
import org.springframework.core.SpringVersion;
import org.springframework.util.Assert;

public class RuntimeEnvironmentInfo {
    private String spiVersion;
    private String implementationName;
    private String implementationVersion;
    private String platformType;
    private String platformApiVersion;
    private String platformClientVersion;
    private String platformHostVersion;
    private String javaVersion;
    private String springVersion;
    private String springBootVersion;
    private Map<String, String> platformSpecificInfo = new HashMap<String, String>();

    private RuntimeEnvironmentInfo(Class spiClass, String implementationName, String implementationVersion, String platformType, String platformApiVersion, String platformClientVersion, String platformHostVersion, Map<String, String> platformSpecificInfo) {
        Assert.notNull((Object)spiClass, (String)"spiClass is required");
        Assert.notNull((Object)implementationName, (String)"implementationName is required");
        Assert.notNull((Object)implementationVersion, (String)"implementationVersion is required");
        Assert.notNull((Object)platformType, (String)"platformType is required");
        Assert.notNull((Object)platformApiVersion, (String)"platformApiVersion is required");
        Assert.notNull((Object)platformClientVersion, (String)"platformClientVersion is required");
        Assert.notNull((Object)platformHostVersion, (String)"platformHostVersion is required");
        this.spiVersion = RuntimeVersionUtils.getVersion(spiClass);
        this.implementationName = implementationName;
        this.implementationVersion = implementationVersion;
        this.platformType = platformType;
        this.platformApiVersion = platformApiVersion;
        this.platformClientVersion = platformClientVersion;
        this.platformHostVersion = platformHostVersion;
        this.javaVersion = System.getProperty("java.version");
        this.springVersion = SpringVersion.getVersion();
        this.springBootVersion = RuntimeVersionUtils.getSpringBootVersion();
        this.platformSpecificInfo.putAll(platformSpecificInfo);
    }

    public String getSpiVersion() {
        return this.spiVersion;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public String getPlatformType() {
        return this.platformType;
    }

    public String getPlatformApiVersion() {
        return this.platformApiVersion;
    }

    public String getPlatformClientVersion() {
        return this.platformClientVersion;
    }

    public String getPlatformHostVersion() {
        return this.platformHostVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getSpringVersion() {
        return this.springVersion;
    }

    public String getSpringBootVersion() {
        return this.springBootVersion;
    }

    public Map<String, String> getPlatformSpecificInfo() {
        return this.platformSpecificInfo;
    }

    public static class Builder {
        private Class spiClass;
        private String implementationName;
        private String implementationVersion;
        private String platformType;
        private String platformApiVersion;
        private String platformClientVersion;
        private String platformHostVersion;
        private Map<String, String> platformSpecificInfo = new HashMap<String, String>();

        public Builder spiClass(Class spiClass) {
            this.spiClass = spiClass;
            return this;
        }

        public Builder implementationName(String implementationName) {
            this.implementationName = implementationName;
            return this;
        }

        public Builder implementationVersion(String implementationVersion) {
            this.implementationVersion = implementationVersion;
            return this;
        }

        public Builder platformType(String platformType) {
            this.platformType = platformType;
            return this;
        }

        public Builder platformApiVersion(String platformApiVersion) {
            this.platformApiVersion = platformApiVersion;
            return this;
        }

        public Builder platformClientVersion(String platformClientVersion) {
            this.platformClientVersion = platformClientVersion;
            return this;
        }

        public Builder platformHostVersion(String platformHostVersion) {
            this.platformHostVersion = platformHostVersion;
            return this;
        }

        public Builder addPlatformSpecificInfo(String key, String value) {
            this.platformSpecificInfo.put(key, value);
            return this;
        }

        public RuntimeEnvironmentInfo build() {
            return new RuntimeEnvironmentInfo(this.spiClass, this.implementationName, this.implementationVersion, this.platformType, this.platformApiVersion, this.platformClientVersion, this.platformHostVersion, this.platformSpecificInfo);
        }
    }
}

