/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.app;

import java.util.Map;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AppScaleRequest {
    private final int count;
    private final String deploymentId;
    private final Optional<Map<String, String>> properties;

    public AppScaleRequest(String deploymentId, int count) {
        this(deploymentId, count, null);
    }

    public AppScaleRequest(String deploymentId, int count, @Nullable Map<String, String> properties) {
        Assert.hasText((String)deploymentId, (String)"'deploymentId', must not be empty or null");
        Assert.state((count >= 0 ? 1 : 0) != 0, (String)"'count' must be >= 0");
        this.deploymentId = deploymentId;
        this.count = count;
        this.properties = Optional.ofNullable(properties);
    }

    public int getCount() {
        return this.count;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Optional<Map<String, String>> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AppScaleRequest{");
        sb.append("count=").append(this.count);
        sb.append(", deploymentId='").append(this.deploymentId).append('\'');
        sb.append(", properties=").append(this.properties);
        sb.append('}');
        return sb.toString();
    }
}

