/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.spi.test.AbstractIntegrationTests;
import org.springframework.cloud.deployer.spi.test.Timeout;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE)
@ContextConfiguration(classes={AbstractIntegrationTests.Config.class})
public abstract class AbstractIntegrationJUnit5Tests {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String testName;
    @Autowired
    protected MavenProperties mavenProperties;

    @BeforeEach
    public void setup(TestInfo testInfo) {
        Optional testMethod = testInfo.getTestMethod();
        testMethod.ifPresent(method -> {
            this.testName = method.getName();
        });
    }

    protected String randomName() {
        return this.testName + "-" + UUID.randomUUID().toString();
    }

    protected Timeout deploymentTimeout() {
        return new Timeout(12, 5000);
    }

    protected Timeout undeploymentTimeout() {
        return new Timeout(20, 5000);
    }

    protected int redeploymentPause() {
        return 0;
    }

    protected Resource testApplication() {
        Properties properties = new Properties();
        try {
            properties.load(new ClassPathResource("integration-test-app.properties").getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to determine which version of spring-cloud-deployer-spi-test-app to use", e);
        }
        return new MavenResource.Builder(this.mavenProperties).groupId("org.springframework.cloud").artifactId("spring-cloud-deployer-spi-test-app").classifier("exec").version(properties.getProperty("version")).extension("jar").build();
    }

    @Configuration
    public static class Config {
        @Bean
        @ConfigurationProperties(value="maven")
        public MavenProperties mavenProperties() {
            return new MavenProperties();
        }
    }
}

