/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.scheduler.test;

import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.deployer.resource.maven.MavenProperties;
import org.springframework.cloud.deployer.resource.maven.MavenResource;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.scheduler.CreateScheduleException;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleInfo;
import org.springframework.cloud.deployer.spi.scheduler.ScheduleRequest;
import org.springframework.cloud.deployer.spi.scheduler.Scheduler;
import org.springframework.cloud.deployer.spi.scheduler.SchedulerException;
import org.springframework.cloud.deployer.spi.scheduler.test.AbstractSchedulerIntegrationTests;
import org.springframework.cloud.deployer.spi.test.Timeout;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE)
@ContextConfiguration(classes={AbstractSchedulerIntegrationTests.Config.class})
public abstract class AbstractSchedulerIntegrationJUnit5Tests {
    @Autowired
    protected MavenProperties mavenProperties;
    private SchedulerWrapper schedulerWrapper;
    private Timeout scheduleTimeout = new Timeout(12, 5000);
    private Timeout unScheduleTimeout = new Timeout(12, 5000);
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String testName;

    @AfterEach
    public void tearDown() {
        ArrayList<ScheduleRequest> scheduleRequests = new ArrayList<ScheduleRequest>(this.schedulerWrapper.getScheduledTasks().values());
        for (ScheduleRequest scheduleRequest : scheduleRequests) {
            this.unscheduleTestSchedule(scheduleRequest.getScheduleName());
        }
    }

    protected Scheduler taskScheduler() {
        return this.schedulerWrapper;
    }

    protected abstract Scheduler provideScheduler();

    protected abstract List<String> getCommandLineArgs();

    protected abstract Map<String, String> getSchedulerProperties();

    protected abstract Map<String, String> getDeploymentProperties();

    protected abstract Map<String, String> getAppProperties();

    @BeforeEach
    public void wrapScheduler(TestInfo testInfo) {
        this.schedulerWrapper = new SchedulerWrapper(this.provideScheduler());
        Optional testMethod = testInfo.getTestMethod();
        if (testMethod.isPresent()) {
            this.testName = ((Method)testMethod.get()).getName();
        }
    }

    @Test
    public void testSimpleSchedule() {
        this.createAndVerifySchedule();
    }

    @Test
    public void testUnschedule() {
        int initialSize = this.taskScheduler().list().size();
        ScheduleInfo scheduleInfo = this.createAndVerifySchedule();
        this.unscheduleTestSchedule(scheduleInfo.getScheduleName());
        Assertions.assertThat((int)(this.taskScheduler().list().size() - initialSize)).isEqualTo(0);
    }

    @Test
    public void testDuplicateSchedule() {
        ScheduleRequest request = this.createScheduleRequest();
        this.taskScheduler().schedule(request);
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(request.getScheduleName());
        this.verifySchedule(scheduleInfo);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskScheduler().schedule(request)).isInstanceOf(CreateScheduleException.class)).hasMessageContaining("Failed to create schedule %s", new Object[]{request.getScheduleName()});
    }

    @Test
    public void testUnScheduleNoEntry() {
        String definitionName = this.randomName();
        String scheduleName = this.scheduleName() + definitionName;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.unscheduleTestSchedule(scheduleName)).isInstanceOf(SchedulerException.class)).hasMessage("Failed to unschedule schedule %s does not exist.", new Object[]{scheduleName});
    }

    @Test
    public void testInvalidCronExpression() {
        String INVALID_EXPRESSION = "BAD";
        String definitionName = this.randomName();
        String scheduleName = this.scheduleName() + definitionName;
        HashMap<String, String> properties = new HashMap<String, String>(this.getDeploymentProperties());
        properties.put("spring.cloud.scheduler.cron.expression", "BAD");
        AppDefinition definition = new AppDefinition(definitionName, properties);
        ScheduleRequest request = new ScheduleRequest(definition, properties, this.getCommandLineArgs(), scheduleName, this.testApplication());
        Assertions.assertThatThrownBy(() -> this.taskScheduler().schedule(request)).isInstanceOf(CreateScheduleException.class);
    }

    @Test
    public void testMultipleSchedule() {
        String definitionName = this.randomName();
        String scheduleName = this.scheduleName() + definitionName;
        for (int i = 0; i < 4; ++i) {
            ScheduleRequest request = this.createScheduleRequest(scheduleName + i, definitionName + i);
            this.taskScheduler().schedule(request);
        }
        List scheduleInfos = this.taskScheduler().list();
        for (ScheduleInfo scheduleInfo : scheduleInfos) {
            this.verifySchedule(scheduleInfo);
        }
    }

    @Test
    public void testListFilter() {
        String definitionName = this.randomName();
        String scheduleName = this.scheduleName() + definitionName;
        for (int i = 0; i < 4; ++i) {
            ScheduleRequest request = this.createScheduleRequest(scheduleName + i, definitionName + i % 2);
            this.taskScheduler().schedule(request);
        }
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(scheduleName + 0);
        scheduleInfo.setTaskDefinitionName(definitionName + 0);
        Awaitility.await().pollInterval(Duration.ofMillis(this.scheduleTimeout.pause)).atMost(Duration.ofMillis(this.scheduleTimeout.maxAttempts * this.scheduleTimeout.pause)).untilAsserted(() -> ListScheduleInfoAssert.assertThat(this.taskScheduler().list(definitionName + 0)).hasExpectedScheduleCount(definitionName + 0, 2));
    }

    public Timeout getScheduleTimeout() {
        return this.scheduleTimeout;
    }

    public void setScheduleTimeout(Timeout scheduleTimeout) {
        this.scheduleTimeout = scheduleTimeout;
    }

    public Timeout getUnScheduleTimeout() {
        return this.unScheduleTimeout;
    }

    public void setUnScheduleTimeout(Timeout unScheduleTimeout) {
        this.unScheduleTimeout = unScheduleTimeout;
    }

    private ScheduleInfo createAndVerifySchedule() {
        ScheduleRequest request = this.createScheduleRequest();
        this.taskScheduler().schedule(request);
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(request.getScheduleName());
        this.verifySchedule(scheduleInfo);
        return scheduleInfo;
    }

    private ScheduleRequest createScheduleRequest() {
        String definitionName = this.randomName();
        String scheduleName = this.scheduleName() + definitionName;
        return this.createScheduleRequest(scheduleName, definitionName);
    }

    private ScheduleRequest createScheduleRequest(String scheduleName, String definitionName) {
        AppDefinition definition = new AppDefinition(definitionName, this.getAppProperties());
        return new ScheduleRequest(definition, this.getDeploymentProperties(), this.getCommandLineArgs(), scheduleName, this.testApplication());
    }

    private void verifySchedule(ScheduleInfo scheduleInfo) {
        Awaitility.await().pollInterval(Duration.ofMillis(this.scheduleTimeout.pause)).atMost(Duration.ofMillis(this.scheduleTimeout.maxAttempts * this.scheduleTimeout.pause)).untilAsserted(() -> ListScheduleInfoAssert.assertThat(this.taskScheduler().list()).hasSchedule(scheduleInfo.getScheduleName()));
    }

    private void unscheduleTestSchedule(String scheduleName) {
        this.log.info("unscheduling {}...", (Object)scheduleName);
        this.taskScheduler().unschedule(scheduleName);
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.setScheduleName(scheduleName);
        Awaitility.await().pollInterval(Duration.ofMillis(this.unScheduleTimeout.pause)).atMost(Duration.ofMillis(this.unScheduleTimeout.maxAttempts * this.unScheduleTimeout.pause)).untilAsserted(() -> ListScheduleInfoAssert.assertThat(this.taskScheduler().list()).hasNotSchedule(scheduleName));
    }

    protected String randomName() {
        return this.testName + "-" + UUID.randomUUID().toString();
    }

    protected String scheduleName() {
        return "ScheduleName_";
    }

    protected Resource testApplication() {
        Properties properties = new Properties();
        try {
            properties.load(new ClassPathResource("integration-test-app.properties").getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to determine which version of spring-cloud-deployer-spi-scheduler-test-app to use", e);
        }
        return new MavenResource.Builder(this.mavenProperties).groupId("org.springframework.cloud").artifactId("spring-cloud-deployer-spi-scheduler-test-app").classifier("exec").version(properties.getProperty("version")).extension("jar").build();
    }

    @Configuration
    public static class Config {
        @Bean
        @ConfigurationProperties(value="maven")
        public MavenProperties mavenProperties() {
            return new MavenProperties();
        }
    }

    protected static class SchedulerWrapper
    implements Scheduler {
        private final Scheduler wrapped;
        private final Map<String, ScheduleRequest> scheduledTasks = new HashMap<String, ScheduleRequest>();

        public SchedulerWrapper(Scheduler wrapped) {
            this.wrapped = wrapped;
        }

        public void schedule(ScheduleRequest scheduleRequest) {
            this.wrapped.schedule(scheduleRequest);
            this.scheduledTasks.put(scheduleRequest.getScheduleName(), scheduleRequest);
        }

        public void unschedule(String scheduleName) {
            this.wrapped.unschedule(scheduleName);
            this.scheduledTasks.remove(scheduleName);
        }

        public List<ScheduleInfo> list(String taskDefinitionName) {
            return this.wrapped.list(taskDefinitionName);
        }

        public List<ScheduleInfo> list() {
            return this.wrapped.list();
        }

        public Map<String, ScheduleRequest> getScheduledTasks() {
            return Collections.unmodifiableMap(this.scheduledTasks);
        }
    }

    protected static class ListScheduleInfoAssert
    extends AbstractAssert<ListScheduleInfoAssert, List<ScheduleInfo>> {
        public ListScheduleInfoAssert(List<ScheduleInfo> scheduleInfos) {
            super(scheduleInfos, ListScheduleInfoAssert.class);
        }

        public static ListScheduleInfoAssert assertThat(List<ScheduleInfo> scheduleInfos) {
            return new ListScheduleInfoAssert(scheduleInfos);
        }

        public ListScheduleInfoAssert hasSchedule(String scheduleName) {
            this.isNotNull();
            if (!((List)this.actual).stream().map(si -> si.getScheduleName()).anyMatch(sc -> sc.equals(scheduleName))) {
                this.failWithMessage("unable to find specified scheduleName <%s> ", new Object[]{scheduleName});
            }
            return this;
        }

        public ListScheduleInfoAssert hasNotSchedule(String scheduleName) {
            this.isNotNull();
            if (((List)this.actual).stream().map(si -> si.getScheduleName()).anyMatch(sc -> sc.equals(scheduleName))) {
                this.failWithMessage("found specified scheduleName <%s> ", new Object[]{scheduleName});
            }
            return this;
        }

        public ListScheduleInfoAssert hasExpectedScheduleCount(String taskDefinitionName, int expectedScheduleCount) {
            this.isNotNull();
            if (((List)this.actual).size() != expectedScheduleCount) {
                this.failWithMessage("given schedule info list doesn't match expected count <%s>, was <%s>", new Object[]{expectedScheduleCount, ((List)this.actual).size()});
            }
            if (!((List)this.actual).stream().map(si -> si.getTaskDefinitionName()).anyMatch(sc -> sc.equals(taskDefinitionName))) {
                this.failWithMessage("found specified scheduleName <%s> ", new Object[]{taskDefinitionName});
            }
            return this;
        }
    }
}

