/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.spi.test;

import java.util.Collections;
import java.util.HashMap;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.deployer.spi.task.LaunchState;
import org.springframework.cloud.deployer.spi.task.TaskLauncher;
import org.springframework.cloud.deployer.spi.task.TaskStatus;
import org.springframework.cloud.deployer.spi.test.AbstractIntegrationTests;
import org.springframework.cloud.deployer.spi.test.EventuallyMatcher;
import org.springframework.cloud.deployer.spi.test.Timeout;
import org.springframework.core.io.Resource;

public abstract class AbstractTaskLauncherIntegrationTests
extends AbstractIntegrationTests {
    protected abstract TaskLauncher taskLauncher();

    @Test
    public void testNonExistentAppsStatus() {
        Assert.assertThat((Object)this.randomName(), this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)CoreMatchers.is((Object)LaunchState.unknown))));
    }

    @Test
    public void testSimpleLaunch() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "0");
        appProperties.put("exitCode", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.record(this.taskLauncher().launch(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)launchId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)LaunchState.complete))), timeout.maxAttempts, timeout.pause));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testReLaunch() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "0");
        appProperties.put("exitCode", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.record(this.taskLauncher().launch(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)launchId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)LaunchState.complete))), timeout.maxAttempts, timeout.pause));
        this.log.info("Re-Launching {}...", (Object)request.getDefinition().getName());
        String newLaunchId = this.record(this.taskLauncher().launch(request));
        Assert.assertThat((Object)newLaunchId, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)launchId)));
        timeout = this.deploymentTimeout();
        Assert.assertThat((Object)newLaunchId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)LaunchState.complete))), timeout.maxAttempts, timeout.pause));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testErrorExit() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "0");
        appProperties.put("exitCode", "1");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.record(this.taskLauncher().launch(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)launchId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)LaunchState.failed))), timeout.maxAttempts, timeout.pause));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testSimpleCancel() throws InterruptedException {
        HashMap<String, String> appProperties = new HashMap<String, String>();
        appProperties.put("killDelay", "-1");
        appProperties.put("exitCode", "0");
        AppDefinition definition = new AppDefinition(this.randomName(), appProperties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource);
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String launchId = this.record(this.taskLauncher().launch(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)launchId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)LaunchState.running))), timeout.maxAttempts, timeout.pause));
        this.log.info("Cancelling {}...", (Object)request.getDefinition().getName());
        this.taskLauncher().cancel(launchId);
        timeout = this.undeploymentTimeout();
        Assert.assertThat((Object)launchId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)LaunchState.cancelled))), timeout.maxAttempts, timeout.pause));
        this.taskLauncher().destroy(definition.getName());
    }

    @Test
    public void testCommandLineArgs() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("killDelay", "1000");
        AppDefinition definition = new AppDefinition(this.randomName(), properties);
        Resource resource = this.testApplication();
        AppDeploymentRequest request = new AppDeploymentRequest(definition, resource, Collections.emptyMap(), Collections.singletonList("--exitCode=0"));
        this.log.info("Launching {}...", (Object)request.getDefinition().getName());
        String deploymentId = this.record(this.taskLauncher().launch(request));
        Timeout timeout = this.deploymentTimeout();
        Assert.assertThat((Object)deploymentId, EventuallyMatcher.eventually(this.hasStatusThat((Matcher<TaskStatus>)Matchers.hasProperty((String)"state", (Matcher)Matchers.is((Object)LaunchState.complete))), timeout.maxAttempts, timeout.pause));
        this.taskLauncher().destroy(definition.getName());
    }

    @After
    public void cleanUp() {
        for (String id : this.deployments) {
            this.taskLauncher().cleanup(id);
        }
    }

    protected Matcher<String> hasStatusThat(final Matcher<TaskStatus> statusMatcher) {
        return new BaseMatcher<String>(){
            private TaskStatus status;

            public boolean matches(Object item) {
                this.status = AbstractTaskLauncherIntegrationTests.this.taskLauncher().status((String)item);
                return statusMatcher.matches((Object)this.status);
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
                mismatchDescription.appendText("status of ").appendValue(item).appendText(" ");
                statusMatcher.describeMismatch((Object)this.status, mismatchDescription);
            }

            public void describeTo(Description description) {
                statusMatcher.describeTo(description);
            }
        };
    }
}

