/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.deployer.resource.docker;

import org.springframework.cloud.deployer.resource.docker.DockerResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DockerResourceLoader
implements ResourceLoader {
    private final ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public Resource getResource(String location) {
        Assert.hasText((String)location, (String)"image location is required");
        String image = location.replaceFirst("docker:\\/*", "");
        return new DockerResource(image);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

